/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.signature;

import com.azure.security.keyvault.jca.KeyVaultEncode;
import com.azure.security.keyvault.jca.implementation.signature.AbstractKeyVaultKeyLessSignature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.Base64;

public abstract class KeyVaultKeyLessECSignature
extends AbstractKeyVaultKeyLessSignature {
    private final String keyVaultDigestName;

    KeyVaultKeyLessECSignature(String digestName, String keyVaultDigestName) {
        try {
            this.messageDigest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.keyVaultDigestName = keyVaultDigestName;
    }

    @Override
    protected byte[] engineSign() {
        byte[] mHash = this.getDigestValue();
        String encode = Base64.getEncoder().encodeToString(mHash);
        byte[] encrypted = this.keyVaultClient.getSignedWithPrivateKey(this.keyVaultDigestName, encode, this.keyId);
        return KeyVaultEncode.encodeByte(encrypted);
    }
}

