/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.signature;

import com.azure.security.keyvault.jca.implementation.signature.AbstractKeyVaultKeyLessSignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Base64;

public class KeyVaultKeyLessRsaSignature
extends AbstractKeyVaultKeyLessSignature {
    public KeyVaultKeyLessRsaSignature() {
        this.messageDigest = null;
    }

    @Override
    protected byte[] engineSign() {
        byte[] mHash = this.getDigestValue();
        String encode = Base64.getEncoder().encodeToString(mHash);
        return this.keyVaultClient.getSignedWithPrivateKey("PS256", encode, this.keyId);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("Parameters cannot be null");
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
        PSSParameterSpec signatureParameters = (PSSParameterSpec)params;
        String newHashAlg = signatureParameters.getDigestAlgorithm();
        if (this.messageDigest == null || !this.messageDigest.getAlgorithm().equalsIgnoreCase(newHashAlg)) {
            try {
                this.messageDigest = MessageDigest.getInstance(newHashAlg);
            }
            catch (NoSuchAlgorithmException exception) {
                throw new InvalidAlgorithmParameterException("Unsupported digest algorithm " + newHashAlg, exception);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "RSASSA-PSS";
    }
}

