/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.utils;

import com.azure.security.keyvault.jca.implementation.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.azure.security.keyvault.jca.implementation.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.azure.security.keyvault.jca.implementation.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JsonConverterUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonConverterUtil.class.getName());

    public static Object fromJson(String string, Class<?> resultClass) {
        LOGGER.entering("JsonConverterUtil", "fromJson", new Object[]{string, resultClass});
        Object result = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            result = objectMapper.readValue(string, resultClass);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Unable to convert from JSON", e);
        }
        LOGGER.exiting("JsonConverterUtil", "fromJson", result);
        return result;
    }

    public static String toJson(Object object) {
        LOGGER.entering("JsonConverterUtil", "toJson", object);
        String result = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            result = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Unable to convert to JSON", e);
        }
        LOGGER.exiting("JsonConverterUtil", "toJson", result);
        return result;
    }
}

