package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.cms;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class CMSConfig
{
    /**
     * Set the mapping for the encryption algorithm used in association with a SignedData generation
     * or interpretation.
     *
     * @param oid object identifier to map.
     * @param algorithmName algorithm name to use.
     */
    public static void setSigningEncryptionAlgorithmMapping(String oid, String algorithmName)
    {
        ASN1ObjectIdentifier id = new ASN1ObjectIdentifier(oid);

        CMSSignedHelper.INSTANCE.setSigningEncryptionAlgorithmMapping(id, algorithmName);
    }
}
