/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import java.math.BigInteger;

public class KeyVaultEncode {
    private static final byte TAG_INTEGER = 2;
    private static final byte TAG_SEQUENCE = 48;

    public static byte[] encodeByte(byte[] signature) {
        int halfLength = signature.length >> 1;
        byte[] leftResult = KeyVaultEncode.toBigIntegerBytesWithLengthPrefix(signature, 0, halfLength);
        byte[] rightResult = KeyVaultEncode.toBigIntegerBytesWithLengthPrefix(signature, halfLength, halfLength);
        byte[] resultLengthBytes = KeyVaultEncode.buildLengthBytes((byte)48, leftResult.length + rightResult.length);
        return KeyVaultEncode.concatBytes(resultLengthBytes, leftResult, rightResult);
    }

    static byte[] toBigIntegerBytesWithLengthPrefix(byte[] bytes, int offset, int length) {
        byte[] magnitude = new byte[length];
        System.arraycopy(bytes, offset, magnitude, 0, length);
        BigInteger bigInteger = new BigInteger(1, magnitude);
        byte[] bigIntegerArray = bigInteger.toByteArray();
        return KeyVaultEncode.concatBytes(KeyVaultEncode.buildLengthBytes((byte)2, bigIntegerArray.length), bigIntegerArray);
    }

    static byte[] concatBytes(byte[] bytes1, byte[] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    static byte[] concatBytes(byte[] bytes1, byte[] bytes2, byte[] bytes3) {
        byte[] result = new byte[bytes1.length + bytes2.length + bytes3.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        System.arraycopy(bytes3, 0, result, bytes1.length + bytes2.length, bytes3.length);
        return result;
    }

    static byte[] buildLengthBytes(byte tag, int len) {
        if (len < 128) {
            return new byte[]{tag, (byte)len};
        }
        if (len < 256) {
            return new byte[]{tag, -127, (byte)len};
        }
        if (len < 65536) {
            return new byte[]{tag, -126, (byte)(len >> 8), (byte)len};
        }
        if (len < 0x1000000) {
            return new byte[]{tag, -125, (byte)(len >> 16), (byte)(len >> 8), (byte)len};
        }
        return new byte[]{tag, -124, (byte)(len >> 24), (byte)(len >> 16), (byte)(len >> 8), (byte)len};
    }
}

