/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultKeyManagerFactory;
import com.azure.security.keyvault.jca.KeyVaultKeyStore;
import com.azure.security.keyvault.jca.implementation.signature.AbstractKeyVaultKeylessSignature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessEcSha256Signature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessEcSha384Signature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessEcSha512Signature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessRsa256Signature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessRsa512Signature;
import com.azure.security.keyvault.jca.implementation.signature.KeyVaultKeylessRsaSsaPssSignature;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;

public final class KeyVaultJcaProvider
extends Provider {
    public static final String PROVIDER_NAME = "AzureKeyVault";
    private static final long serialVersionUID = 1L;
    private static final String INFO = "Azure Key Vault JCA Provider";
    private static final Double VERSION = 1.0;

    public KeyVaultJcaProvider() {
        super(PROVIDER_NAME, VERSION, INFO);
        this.initialize();
    }

    private void initialize() {
        AccessController.doPrivileged(() -> {
            this.putService(new Provider.Service(this, "KeyManagerFactory", "SunX509", KeyVaultKeyManagerFactory.class.getName(), Arrays.asList("SunX509", "IbmX509"), null));
            this.putService(new Provider.Service(this, "KeyStore", "DKS", KeyVaultKeyStore.class.getName(), Collections.singletonList("DKS"), null));
            this.putService(new Provider.Service(this, "KeyStore", PROVIDER_NAME, KeyVaultKeyStore.class.getName(), Collections.singletonList(PROVIDER_NAME), null));
            Stream.of(KeyVaultKeylessRsaSsaPssSignature.class, KeyVaultKeylessRsa256Signature.class, KeyVaultKeylessRsa512Signature.class, KeyVaultKeylessEcSha256Signature.class, KeyVaultKeylessEcSha384Signature.class, KeyVaultKeylessEcSha512Signature.class).forEach((? super T c) -> this.putService(new Provider.Service(this, "Signature", this.getAlgorithmName((Class<? extends AbstractKeyVaultKeylessSignature>)c), c.getName(), null, null)));
            return null;
        });
    }

    private String getAlgorithmName(Class<? extends AbstractKeyVaultKeylessSignature> c) {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getAlgorithmName();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return "";
        }
    }
}

