/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.digests;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServiceProperties;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.Digest;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.SavableDigestXof;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.digests.SHAKENativeDigest;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.digests.Utils;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.Memoable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SHAKENativeDigest
implements SavableDigestXof {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;
    private int bitLen;

    public SHAKENativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this(128, cryptoServicePurpose);
    }

    public SHAKENativeDigest(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (!CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            throw new IllegalStateException("no native SHAKE support");
        }
        this.purpose = cryptoServicePurpose;
        this.bitLen = n;
        this.nativeRef = new DigestRefWrapper(SHAKENativeDigest.makeNative((int)n));
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    public SHAKENativeDigest(int n) {
        this(n, CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest(SHAKENativeDigest sHAKENativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHAKENativeDigest.getEncodedState();
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)0);
    }

    public SHAKENativeDigest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this(cryptoServicePurpose);
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)0);
    }

    public SHAKENativeDigest(byte[] byArray) {
        this();
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)0);
    }

    SHAKENativeDigest restoreState(byte[] byArray, int n) {
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)n);
        return this;
    }

    public String getAlgorithmName() {
        return "SHAKE" + this.bitLen;
    }

    public int getDigestSize() {
        return SHAKENativeDigest.getDigestSize((long)this.nativeRef.getReference());
    }

    public void update(byte by) {
        SHAKENativeDigest.update((long)this.nativeRef.getReference(), (byte)by);
    }

    public void update(byte[] byArray, int n, int n2) {
        SHAKENativeDigest.update((long)this.nativeRef.getReference(), (byte[])byArray, (int)n, (int)n2);
    }

    public int doFinal(byte[] byArray, int n) {
        int n2 = SHAKENativeDigest.doFinal((long)this.nativeRef.getReference(), (byte[])byArray, (int)n);
        return n2;
    }

    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = SHAKENativeDigest.doFinal((long)this.nativeRef.getReference(), (byte[])byArray, (int)n, (int)n2);
        return n3;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        return SHAKENativeDigest.doOutput((long)this.nativeRef.getReference(), (byte[])byArray, (int)n, (int)n2);
    }

    public void reset() {
        SHAKENativeDigest.reset((long)this.nativeRef.getReference());
    }

    public int getByteLength() {
        return SHAKENativeDigest.getByteLength((long)this.nativeRef.getReference());
    }

    public Memoable copy() {
        return new SHAKENativeDigest(this);
    }

    public void reset(Memoable memoable) {
        SHAKENativeDigest sHAKENativeDigest = (SHAKENativeDigest)memoable;
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])sHAKENativeDigest.getEncodedState(), (int)0);
    }

    public byte[] getEncodedState() {
        int n = SHAKENativeDigest.encodeFullState((long)this.nativeRef.getReference(), null, (int)0);
        byte[] byArray = new byte[n];
        SHAKENativeDigest.encodeFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)0);
        return byArray;
    }

    void restoreFullState(byte[] byArray, int n) {
        SHAKENativeDigest.restoreFullState((long)this.nativeRef.getReference(), (byte[])byArray, (int)n);
    }

    public String toString() {
        return "SHAKE[Native]()";
    }

    static native long makeNative(int var0);

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native int doOutput(long var0, byte[] var2, int var3, int var4);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties((Digest)this, this.bitLen, this.purpose);
    }
}

