/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.SavableDigestXof;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.digests.SHAKEDigest;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class Fingerprint {
    private static char[] encodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] fingerprint;

    public Fingerprint(byte[] byArray) {
        this(byArray, 160);
    }

    public Fingerprint(byte[] byArray, int n) {
        this.fingerprint = Fingerprint.calculateFingerprint((byte[])byArray, (int)n);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i != this.fingerprint.length; ++i) {
            if (i > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(encodingTable[this.fingerprint[i] >>> 4 & 0xF]);
            stringBuffer.append(encodingTable[this.fingerprint[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)object).fingerprint, this.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fingerprint);
    }

    public static byte[] calculateFingerprint(byte[] byArray) {
        return Fingerprint.calculateFingerprint((byte[])byArray, (int)160);
    }

    public static byte[] calculateFingerprint(byte[] byArray, int n) {
        if (n % 8 != 0) {
            throw new IllegalArgumentException("bitLength must be a multiple of 8");
        }
        SavableDigestXof savableDigestXof = SHAKEDigest.newInstance((int)256);
        savableDigestXof.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n / 8];
        savableDigestXof.doFinal(byArray2, 0, n / 8);
        return byArray2;
    }
}

