/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultTrustManager;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public final class KeyVaultTrustManagerFactory
extends TrustManagerFactorySpi {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultTrustManagerFactory.class.getName());
    private final List<TrustManager> trustManagers = new ArrayList<TrustManager>();

    @Override
    protected void engineInit(KeyStore keystore) {
        LOGGER.entering("KeyVaultKeyManagerFactory", "engineInit", keystore);
        this.trustManagers.add(new KeyVaultTrustManager(keystore));
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) {
        LOGGER.entering("KeyVaultKeyManagerFactory", "engineInit", spec);
        this.trustManagers.add(new KeyVaultTrustManager());
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return this.trustManagers.toArray(new TrustManager[0]);
    }
}

