/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.signature;

import com.azure.security.keyvault.jca.implementation.signature.AbstractKeyVaultKeylessSignature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.Base64;

abstract class KeyVaultKeylessRsaSignature
extends AbstractKeyVaultKeylessSignature {
    private final String keyVaultDigestName;

    KeyVaultKeylessRsaSignature(String digestName, String keyVaultDigestName) {
        if (digestName != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(digestName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException(e);
            }
        }
        this.keyVaultDigestName = keyVaultDigestName;
    }

    @Override
    protected byte[] engineSign() {
        byte[] mHash = this.getDigestValue();
        String encode = Base64.getEncoder().encodeToString(mHash);
        if (this.keyVaultClient != null) {
            return this.keyVaultClient.getSignedWithPrivateKey(this.keyVaultDigestName, encode, this.keyId);
        }
        return new byte[0];
    }
}

