/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.KeyVaultKey;

public class CryptographyClient {
    private final CryptographyAsyncClient client;

    CryptographyClient(CryptographyAsyncClient client) {
        this.client = client;
    }

    public KeyVaultKey getKey() {
        return (KeyVaultKey)this.getKeyWithResponse(Context.NONE).getValue();
    }

    public Response<KeyVaultKey> getKeyWithResponse(Context context) {
        return (Response)this.client.getKeyWithResponse(context).block();
    }

    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        return (EncryptResult)this.client.encrypt(algorithm, plaintext, context).block();
    }

    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        return this.encrypt(algorithm, plaintext, Context.NONE);
    }

    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] cipherText, Context context) {
        return (DecryptResult)this.client.decrypt(algorithm, cipherText, context).block();
    }

    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] cipherText) {
        return this.decrypt(algorithm, cipherText, Context.NONE);
    }

    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        return (SignResult)this.client.sign(algorithm, digest, context).block();
    }

    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest) {
        return (SignResult)this.client.sign(algorithm, digest, Context.NONE).block();
    }

    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verify(algorithm, digest, signature, Context.NONE);
    }

    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        return (VerifyResult)this.client.verify(algorithm, digest, signature, context).block();
    }

    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        return this.wrapKey(algorithm, key, Context.NONE);
    }

    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        return (WrapResult)this.client.wrapKey(algorithm, key, context).block();
    }

    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        return this.unwrapKey(algorithm, encryptedKey, Context.NONE);
    }

    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        return (UnwrapResult)this.client.unwrapKey(algorithm, encryptedKey, context).block();
    }

    public SignResult signData(SignatureAlgorithm algorithm, byte[] data) {
        return this.signData(algorithm, data, Context.NONE);
    }

    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        return (SignResult)this.client.signData(algorithm, data, context).block();
    }

    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        return this.verifyData(algorithm, data, signature, Context.NONE);
    }

    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        return (VerifyResult)this.client.verifyData(algorithm, data, signature, context).block();
    }

    CryptographyServiceClient getServiceClient() {
        return this.client.getCryptographyServiceClient();
    }
}

