/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;

public final class DecryptResult {
    private final byte[] plainText;
    private final EncryptionAlgorithm algorithm;
    private final String keyId;

    public DecryptResult(byte[] plainText, EncryptionAlgorithm algorithm, String keyId) {
        this.plainText = CoreUtils.clone((byte[])plainText);
        this.algorithm = algorithm;
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public byte[] getPlainText() {
        return CoreUtils.clone((byte[])this.plainText);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

