/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.implementation.SecretMinClientImpl;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyOperationResult;
import com.azure.security.keyvault.keys.implementation.models.KeyOperationsParameters;
import com.azure.security.keyvault.keys.implementation.models.KeySignParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.azure.security.keyvault.keys.implementation.models.KeyVerifyParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVerifyResult;
import com.azure.security.keyvault.keys.implementation.models.SecretKey;
import com.azure.security.keyvault.keys.implementation.models.SecretRequestAttributes;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class CryptographyClientImpl {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClientImpl.class);
    private final KeyClientImpl keyClient;
    private final SecretMinClientImpl secretClient;
    private final String keyId;
    private final String vaultUrl;
    private final String keyCollection;
    private final String keyName;
    private final String keyVersion;

    public CryptographyClientImpl(String keyId, HttpPipeline pipeline, CryptographyServiceVersion serviceVersion) {
        Objects.requireNonNull(keyId);
        List<String> data = CryptographyUtils.unpackAndValidateId(keyId, LOGGER);
        this.vaultUrl = data.get(0);
        this.keyCollection = data.get(1);
        this.keyName = data.get(2);
        this.keyVersion = data.get(3);
        this.keyId = keyId;
        this.keyClient = new KeyClientImpl(pipeline, this.vaultUrl, KeyServiceVersion.valueOf(serviceVersion.toString()));
        this.secretClient = new SecretMinClientImpl(pipeline, serviceVersion.getVersion());
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getKeyCollection() {
        return this.keyCollection;
    }

    public Mono<Response<KeyVaultKey>> getKeyAsync() {
        return this.keyClient.getKeyWithResponseAsync(this.keyName, this.keyVersion, KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapGetKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
    }

    public Response<KeyVaultKey> getKey(Context context) {
        Response<BinaryData> response = this.keyClient.getKeyWithResponse(this.keyName, this.keyVersion, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    public Mono<JsonWebKey> getSecretKeyAsync() {
        return FluxUtil.withContext(context -> this.secretClient.getSecretWithResponseAsync(this.vaultUrl, this.keyName, this.keyVersion, (Context)context)).map(response -> CryptographyUtils.transformSecretKey((SecretKey)response.getValue()));
    }

    public JsonWebKey getSecretKey() {
        return CryptographyUtils.transformSecretKey((SecretKey)this.secretClient.getSecretWithResponse(this.vaultUrl, this.keyName, this.keyVersion, Context.NONE).getValue());
    }

    public Mono<Response<SecretKey>> setSecretKeyAsync(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The secret key cannot be null.");
        return this.secretClient.setSecretWithResponseAsync(this.vaultUrl, secret.getName(), secret.getValue(), secret.getProperties().getTags(), secret.getProperties().getContentType(), new SecretRequestAttributes(secret.getProperties()), context);
    }

    public Response<SecretKey> setSecretKey(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        return this.secretClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), secret.getProperties().getTags(), secret.getProperties().getContentType(), new SecretRequestAttributes(secret.getProperties()), context);
    }

    public Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        return this.encryptAsync(algorithm, plaintext, null, null, context);
    }

    public Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encryptAsync(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), context);
    }

    private Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plainText, byte[] iv, byte[] additionalAuthenticatedData, Context context) {
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), plainText).setIv(iv).setAad(additionalAuthenticatedData);
        return this.keyClient.encryptWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyOperationResult result = (KeyOperationResult)((BinaryData)response.getValue()).toObject(KeyOperationResult.class);
            return new EncryptResult(result.getResult(), algorithm, this.keyId, result.getIv(), result.getAuthenticationTag(), result.getAdditionalAuthenticatedData());
        });
    }

    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        return this.encrypt(algorithm, plaintext, null, null, context);
    }

    public EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encrypt(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), context);
    }

    private EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plainText, byte[] iv, byte[] additionalAuthenticatedData, Context context) {
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), plainText).setIv(iv).setAad(additionalAuthenticatedData);
        KeyOperationResult result = (KeyOperationResult)((BinaryData)this.keyClient.encryptWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyOperationResult.class);
        return new EncryptResult(result.getResult(), algorithm, this.keyId, result.getIv(), result.getAuthenticationTag(), result.getAdditionalAuthenticatedData());
    }

    public Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        return this.decryptAsync(algorithm, ciphertext, null, null, null, context);
    }

    public Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decryptAsync(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), context);
    }

    private Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, Context context) {
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), ciphertext).setIv(iv).setAad(additionalAuthenticatedData).setTag(authenticationTag);
        return this.keyClient.decryptWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyOperationResult result = (KeyOperationResult)((BinaryData)response.getValue()).toObject(KeyOperationResult.class);
            return new DecryptResult(result.getResult(), algorithm, this.keyId);
        });
    }

    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        return this.decrypt(algorithm, ciphertext, null, null, null, context);
    }

    public DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decrypt(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), context);
    }

    private DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, Context context) {
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), ciphertext).setIv(iv).setAad(additionalAuthenticatedData).setTag(authenticationTag);
        KeyOperationResult result = (KeyOperationResult)((BinaryData)this.keyClient.decryptWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyOperationResult.class);
        return new DecryptResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        KeySignParameters keyOperationsParameters = new KeySignParameters(CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest);
        return this.keyClient.signWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyOperationResult result = (KeyOperationResult)((BinaryData)response.getValue()).toObject(KeyOperationResult.class);
            return new SignResult(result.getResult(), algorithm, this.keyId);
        });
    }

    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        KeySignParameters keyOperationsParameters = new KeySignParameters(CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest);
        KeyOperationResult result = (KeyOperationResult)((BinaryData)this.keyClient.signWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyOperationResult.class);
        return new SignResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        KeyVerifyParameters keyVerifyParameters = new KeyVerifyParameters(CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, signature);
        return this.keyClient.verifyWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyVerifyParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyVerifyResult result = (KeyVerifyResult)((BinaryData)response.getValue()).toObject(KeyVerifyResult.class);
            return new VerifyResult(result.isValue(), algorithm, this.keyId);
        });
    }

    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        KeyVerifyParameters keyVerifyParameters = new KeyVerifyParameters(CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, signature);
        KeyVerifyResult result = (KeyVerifyResult)((BinaryData)this.keyClient.verifyWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyVerifyParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyVerifyResult.class);
        return new VerifyResult(result.isValue(), algorithm, this.keyId);
    }

    public Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapWrapAlgorithm(algorithm), key);
        return this.keyClient.wrapKeyWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyOperationResult result = (KeyOperationResult)((BinaryData)response.getValue()).toObject(KeyOperationResult.class);
            return new WrapResult(result.getResult(), algorithm, this.keyId);
        });
    }

    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapWrapAlgorithm(algorithm), key);
        KeyOperationResult result = (KeyOperationResult)((BinaryData)this.keyClient.wrapKeyWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyOperationResult.class);
        return new WrapResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapWrapAlgorithm(algorithm), encryptedKey);
        return this.keyClient.unwrapKeyWithResponseAsync(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).map(response -> {
            KeyOperationResult result = (KeyOperationResult)((BinaryData)response.getValue()).toObject(KeyOperationResult.class);
            return new UnwrapResult(result.getResult(), algorithm, this.keyId);
        });
    }

    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        KeyOperationsParameters keyOperationsParameters = new KeyOperationsParameters(CryptographyUtils.mapWrapAlgorithm(algorithm), encryptedKey);
        KeyOperationResult result = (KeyOperationResult)((BinaryData)this.keyClient.unwrapKeyWithResponse(this.keyName, this.keyVersion, BinaryData.fromObject((Object)keyOperationsParameters), new RequestOptions().setContext(context)).getValue()).toObject(KeyOperationResult.class);
        return new UnwrapResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.signAsync(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.sign(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verifyAsync(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verify(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

