/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class KeyAttestation
implements JsonSerializable<KeyAttestation> {
    private Base64Url certificatePemFile;
    private Base64Url privateKeyAttestation;
    private Base64Url publicKeyAttestation;
    private String version;

    public byte[] getCertificatePemFile() {
        if (this.certificatePemFile == null) {
            return null;
        }
        return this.certificatePemFile.decodedBytes();
    }

    public KeyAttestation setCertificatePemFile(byte[] certificatePemFile) {
        this.certificatePemFile = certificatePemFile == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])certificatePemFile));
        return this;
    }

    public byte[] getPrivateKeyAttestation() {
        if (this.privateKeyAttestation == null) {
            return null;
        }
        return this.privateKeyAttestation.decodedBytes();
    }

    public KeyAttestation setPrivateKeyAttestation(byte[] privateKeyAttestation) {
        this.privateKeyAttestation = privateKeyAttestation == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])privateKeyAttestation));
        return this;
    }

    public byte[] getPublicKeyAttestation() {
        if (this.publicKeyAttestation == null) {
            return null;
        }
        return this.publicKeyAttestation.decodedBytes();
    }

    public KeyAttestation setPublicKeyAttestation(byte[] publicKeyAttestation) {
        this.publicKeyAttestation = publicKeyAttestation == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])publicKeyAttestation));
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public KeyAttestation setVersion(String version) {
        this.version = version;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificatePemFile", Objects.toString(this.certificatePemFile, null));
        jsonWriter.writeStringField("privateKeyAttestation", Objects.toString(this.privateKeyAttestation, null));
        jsonWriter.writeStringField("publicKeyAttestation", Objects.toString(this.publicKeyAttestation, null));
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static KeyAttestation fromJson(JsonReader jsonReader) throws IOException {
        return (KeyAttestation)jsonReader.readObject(reader -> {
            KeyAttestation deserializedKeyAttestation = new KeyAttestation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificatePemFile".equals(fieldName)) {
                    deserializedKeyAttestation.certificatePemFile = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("privateKeyAttestation".equals(fieldName)) {
                    deserializedKeyAttestation.privateKeyAttestation = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("publicKeyAttestation".equals(fieldName)) {
                    deserializedKeyAttestation.publicKeyAttestation = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedKeyAttestation.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyAttestation;
        });
    }
}

