/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.DeletionRecoveryLevel;
import com.azure.security.keyvault.keys.implementation.models.KeyAttestation;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class KeyAttributes
implements JsonSerializable<KeyAttributes> {
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;
    private Integer recoverableDays;
    private DeletionRecoveryLevel recoveryLevel;
    private Boolean exportable;
    private String hsmPlatform;
    private KeyAttestation attestation;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public KeyAttributes setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.notBefore), ZoneOffset.UTC);
    }

    public KeyAttributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(notBefore.toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expires), ZoneOffset.UTC);
    }

    public KeyAttributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(expires.toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyAttributes setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public String getHsmPlatform() {
        return this.hsmPlatform;
    }

    public KeyAttestation getAttestation() {
        return this.attestation;
    }

    public KeyAttributes setAttestation(KeyAttestation attestation) {
        this.attestation = attestation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", (Number)this.notBefore);
        jsonWriter.writeNumberField("exp", (Number)this.expires);
        jsonWriter.writeBooleanField("exportable", this.exportable);
        jsonWriter.writeJsonField("attestation", (JsonSerializable)this.attestation);
        return jsonWriter.writeEndObject();
    }

    public static KeyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (KeyAttributes)jsonReader.readObject(reader -> {
            KeyAttributes deserializedKeyAttributes = new KeyAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedKeyAttributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    deserializedKeyAttributes.notBefore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    deserializedKeyAttributes.expires = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedKeyAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedKeyAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    deserializedKeyAttributes.recoverableDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedKeyAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                if ("exportable".equals(fieldName)) {
                    deserializedKeyAttributes.exportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hsmPlatform".equals(fieldName)) {
                    deserializedKeyAttributes.hsmPlatform = reader.getString();
                    continue;
                }
                if ("attestation".equals(fieldName)) {
                    deserializedKeyAttributes.attestation = KeyAttestation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyAttributes;
        });
    }
}

