/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.security.keyvault.keys.implementation.DeletedKeyHelper;
import com.azure.security.keyvault.keys.implementation.KeyAttestationHelper;
import com.azure.security.keyvault.keys.implementation.KeyPropertiesHelper;
import com.azure.security.keyvault.keys.implementation.KeyRotationPolicyHelper;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeyHelper;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.azure.security.keyvault.keys.implementation.models.KeyAttestation;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class KeyVaultKeysModelsUtils {
    public static KeyVaultKey createKeyVaultKey(KeyBundle keyBundle) {
        if (keyBundle == null) {
            return null;
        }
        KeyVaultKey keyVaultKey = KeyVaultKeyHelper.createKeyVaultKey(KeyVaultKeysModelsUtils.mapJsonWebKeyFromImpl(keyBundle.getKey()));
        KeyVaultKeysModelsUtils.populateKeyProperties(keyBundle, keyVaultKey.getProperties());
        return keyVaultKey;
    }

    public static KeyProperties createKeyProperties(KeyItem keyItem) {
        if (keyItem == null) {
            return null;
        }
        KeyProperties properties = new KeyProperties();
        KeyVaultKeysModelsUtils.populateKeyProperties(keyItem, properties);
        return properties;
    }

    private static void populateKeyProperties(KeyItem keyItem, KeyProperties properties) {
        if (keyItem != null) {
            KeyVaultKeysModelsUtils.populateKeyProperties(null, keyItem.getTags(), keyItem.isManaged(), keyItem.getKid(), properties, keyItem.getAttributes());
        }
    }

    private static void populateKeyProperties(DeletedKeyItem item, KeyProperties properties) {
        if (item != null) {
            KeyVaultKeysModelsUtils.populateKeyProperties(null, item.getTags(), item.isManaged(), item.getKid(), properties, item.getAttributes());
        }
    }

    public static DeletedKey createDeletedKey(DeletedKeyBundle bundle) {
        if (bundle == null) {
            return null;
        }
        DeletedKey deletedKey = DeletedKeyHelper.createDeletedKey(KeyVaultKeysModelsUtils.mapJsonWebKeyFromImpl(bundle.getKey()));
        KeyVaultKeysModelsUtils.populateKeyProperties(bundle, deletedKey.getProperties());
        DeletedKeyHelper.setRecoveryId(deletedKey, bundle.getRecoveryId());
        DeletedKeyHelper.setScheduledPurgeDate(deletedKey, bundle.getScheduledPurgeDate());
        DeletedKeyHelper.setDeletedOn(deletedKey, bundle.getDeletedDate());
        return deletedKey;
    }

    public static DeletedKey createDeletedKey(DeletedKeyItem item) {
        if (item == null) {
            return null;
        }
        DeletedKey deletedKey = new DeletedKey();
        KeyVaultKeysModelsUtils.populateKeyProperties(item, deletedKey.getProperties());
        DeletedKeyHelper.setRecoveryId(deletedKey, item.getRecoveryId());
        DeletedKeyHelper.setDeletedOn(deletedKey, item.getDeletedDate());
        DeletedKeyHelper.setScheduledPurgeDate(deletedKey, item.getScheduledPurgeDate());
        return deletedKey;
    }

    private static com.azure.security.keyvault.keys.models.JsonWebKey mapJsonWebKeyFromImpl(JsonWebKey impl) {
        if (impl == null) {
            return null;
        }
        return new com.azure.security.keyvault.keys.models.JsonWebKey().setId(impl.getKid()).setKeyType(impl.getKty()).setKeyOps(impl.getKeyOps() == null ? null : impl.getKeyOps().stream().map(KeyOperation::fromString).collect(Collectors.toList())).setN(impl.getN()).setE(impl.getE()).setD(impl.getD()).setDp(impl.getDp()).setDq(impl.getDq()).setQi(impl.getQi()).setP(impl.getP()).setQ(impl.getQ()).setK(impl.getK()).setT(impl.getT()).setCurveName(impl.getCrv()).setX(impl.getX()).setY(impl.getY());
    }

    public static JsonWebKey mapJsonWebKey(com.azure.security.keyvault.keys.models.JsonWebKey key) {
        if (key == null) {
            return null;
        }
        return new JsonWebKey().setKid(key.getId()).setKty(key.getKeyType()).setKeyOps(key.getKeyOps().stream().map(ExpandableStringEnum::toString).collect(Collectors.toList())).setN(key.getN()).setE(key.getE()).setD(key.getD()).setDp(key.getDp()).setDq(key.getDq()).setQi(key.getQi()).setP(key.getP()).setQ(key.getQ()).setK(key.getK()).setT(key.getT()).setCrv(key.getCurveName()).setX(key.getX()).setY(key.getY());
    }

    public static KeyAttributes createKeyAttributes(CreateKeyOptions options) {
        if (options == null) {
            return null;
        }
        return new KeyAttributes().setEnabled(options.isEnabled()).setExportable(options.isExportable()).setExpires(options.getExpiresOn()).setNotBefore(options.getNotBefore());
    }

    public static KeyAttributes createKeyAttributes(KeyProperties properties) {
        if (properties == null) {
            return null;
        }
        return new KeyAttributes().setEnabled(properties.isEnabled()).setExportable(properties.isExportable()).setExpires(properties.getExpiresOn()).setNotBefore(properties.getNotBefore());
    }

    private static void populateKeyProperties(KeyBundle bundle, KeyProperties properties) {
        if (bundle != null) {
            KeyVaultKeysModelsUtils.populateKeyProperties(KeyVaultKeysModelsUtils.mapKeyReleasePolicyImpl(bundle.getReleasePolicy()), bundle.getTags(), bundle.isManaged(), bundle.getKey().getKid(), properties, bundle.getAttributes());
        }
    }

    private static void populateKeyProperties(DeletedKeyBundle bundle, KeyProperties properties) {
        if (bundle != null) {
            KeyVaultKeysModelsUtils.populateKeyProperties(KeyVaultKeysModelsUtils.mapKeyReleasePolicyImpl(bundle.getReleasePolicy()), bundle.getTags(), bundle.isManaged(), bundle.getKey().getKid(), properties, bundle.getAttributes());
        }
    }

    private static void populateKeyProperties(com.azure.security.keyvault.keys.models.KeyReleasePolicy keyReleasePolicy, Map<String, String> tags, Boolean isManaged, String kid, KeyProperties properties, KeyAttributes attributes) {
        properties.setReleasePolicy(keyReleasePolicy).setTags(tags);
        KeyPropertiesHelper.setManaged(properties, isManaged);
        KeyPropertiesHelper.setId(properties, kid);
        KeyVaultKeysModelsUtils.unpackId(kid, name -> KeyPropertiesHelper.setName(properties, name), version -> KeyPropertiesHelper.setVersion(properties, version));
        if (attributes != null) {
            properties.setEnabled(attributes.isEnabled()).setExportable(attributes.isExportable()).setNotBefore(attributes.getNotBefore()).setExpiresOn(attributes.getExpires());
            KeyPropertiesHelper.setCreatedOn(properties, attributes.getCreated());
            KeyPropertiesHelper.setUpdatedOn(properties, attributes.getUpdated());
            KeyPropertiesHelper.setRecoveryLevel(properties, Objects.toString((Object)attributes.getRecoveryLevel(), null));
            KeyPropertiesHelper.setRecoverableDays(properties, attributes.getRecoverableDays());
            KeyPropertiesHelper.setHsmPlatform(properties, attributes.getHsmPlatform());
            KeyPropertiesHelper.setKeyAttestation(properties, KeyVaultKeysModelsUtils.mapKeyAttestationImpl(attributes.getAttestation()));
        }
    }

    public static KeyReleasePolicy mapKeyReleasePolicy(com.azure.security.keyvault.keys.models.KeyReleasePolicy policy) {
        if (policy == null) {
            return null;
        }
        return new KeyReleasePolicy().setContentType(policy.getContentType()).setImmutable(policy.isImmutable()).setEncodedPolicy(policy.getEncodedPolicy().toBytes());
    }

    private static com.azure.security.keyvault.keys.models.KeyReleasePolicy mapKeyReleasePolicyImpl(KeyReleasePolicy impl) {
        if (impl == null) {
            return null;
        }
        return new com.azure.security.keyvault.keys.models.KeyReleasePolicy(BinaryData.fromBytes((byte[])impl.getEncodedPolicy())).setContentType(impl.getContentType()).setImmutable(impl.isImmutable());
    }

    public static com.azure.security.keyvault.keys.models.KeyRotationPolicy mapKeyRotationPolicyImpl(KeyRotationPolicy impl) {
        return impl == null ? null : KeyRotationPolicyHelper.createPolicy(impl);
    }

    public static KeyRotationPolicy mapKeyRotationPolicy(com.azure.security.keyvault.keys.models.KeyRotationPolicy policy) {
        if (policy == null) {
            return null;
        }
        return KeyRotationPolicyHelper.getImpl(policy);
    }

    private static com.azure.security.keyvault.keys.models.KeyAttestation mapKeyAttestationImpl(KeyAttestation impl) {
        return impl == null ? null : KeyAttestationHelper.createKeyAttestation(impl);
    }

    private static void unpackId(String keyId, Consumer<String> nameConsumer, Consumer<String> versionConsumer) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            return;
        }
        try {
            URL url = new URL(keyId);
            String[] tokens = url.getPath().split("/");
            if (tokens.length >= 3) {
                nameConsumer.accept(tokens[2]);
            }
            if (tokens.length >= 4) {
                versionConsumer.accept(tokens[3]);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private KeyVaultKeysModelsUtils() {
    }
}

