/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.implementation.KeyAttestationHelper;

public final class KeyAttestation {
    private final byte[] certificatePemFile;
    private final byte[] privateKeyAttestation;
    private final byte[] publicKeyAttestation;
    private final String version;

    public KeyAttestation() {
        this(new com.azure.security.keyvault.keys.implementation.models.KeyAttestation());
    }

    KeyAttestation(com.azure.security.keyvault.keys.implementation.models.KeyAttestation impl) {
        this.certificatePemFile = impl.getCertificatePemFile();
        this.privateKeyAttestation = impl.getPrivateKeyAttestation();
        this.publicKeyAttestation = impl.getPublicKeyAttestation();
        this.version = impl.getVersion();
    }

    public byte[] getCertificatePemFile() {
        return CoreUtils.clone((byte[])this.certificatePemFile);
    }

    public byte[] getPrivateKeyAttestation() {
        return CoreUtils.clone((byte[])this.privateKeyAttestation);
    }

    public byte[] getPublicKeyAttestation() {
        return CoreUtils.clone((byte[])this.publicKeyAttestation);
    }

    public String getVersion() {
        return this.version;
    }

    static {
        KeyAttestationHelper.setAccessor(new KeyAttestationHelper.KeyAttestationAccessor(){

            @Override
            public KeyAttestation createKeyAttestation(com.azure.security.keyvault.keys.implementation.models.KeyAttestation impl) {
                return new KeyAttestation(impl);
            }
        });
    }
}

