// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A KeyBundle consisting of a WebKey plus its attributes.
 */
@Immutable
public final class KeyBundle implements JsonSerializable<KeyBundle> {
    /*
     * The Json web key.
     */
    @Generated
    private JsonWebKey key;

    /*
     * The key management attributes.
     */
    @Generated
    private KeyAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be
     * true.
     */
    @Generated
    private Boolean managed;

    /*
     * The policy rules under which the key can be exported.
     */
    @Generated
    private KeyReleasePolicy releasePolicy;

    /**
     * Creates an instance of KeyBundle class.
     */
    @Generated
    private KeyBundle() {
    }

    /**
     * Get the key property: The Json web key.
     * 
     * @return the key value.
     */
    @Generated
    public JsonWebKey getKey() {
        return this.key;
    }

    /**
     * Get the attributes property: The key management attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the managed property: True if the key's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     * 
     * @return the managed value.
     */
    @Generated
    public Boolean isManaged() {
        return this.managed;
    }

    /**
     * Get the releasePolicy property: The policy rules under which the key can be exported.
     * 
     * @return the releasePolicy value.
     */
    @Generated
    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyBundle if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the KeyBundle.
     */
    @Generated
    public static KeyBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyBundle deserializedKeyBundle = new KeyBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedKeyBundle.key = JsonWebKey.fromJson(reader);
                } else if ("attributes".equals(fieldName)) {
                    deserializedKeyBundle.attributes = KeyAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyBundle.tags = tags;
                } else if ("managed".equals(fieldName)) {
                    deserializedKeyBundle.managed = reader.getNullable(JsonReader::getBoolean);
                } else if ("release_policy".equals(fieldName)) {
                    deserializedKeyBundle.releasePolicy = KeyReleasePolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyBundle;
        });
    }
}
