// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key operations parameters.
 */
@Immutable
public final class KeySignParameters implements JsonSerializable<KeySignParameters> {
    /*
     * The signing/verification algorithm identifier. For more information on possible algorithm types, see
     * JsonWebKeySignatureAlgorithm.
     */
    @Generated
    private final JsonWebKeySignatureAlgorithm algorithm;

    /*
     * The value to operate on.
     */
    @Generated
    private final Base64Url value;

    /**
     * Creates an instance of KeySignParameters class.
     * 
     * @param algorithm the algorithm value to set.
     * @param value the value value to set.
     */
    @Generated
    public KeySignParameters(JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        if (value == null) {
            this.value = null;
        } else {
            this.value = Base64Url.encode(value);
        }
    }

    /**
     * Get the algorithm property: The signing/verification algorithm identifier. For more information on possible
     * algorithm types, see JsonWebKeySignatureAlgorithm.
     * 
     * @return the algorithm value.
     */
    @Generated
    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    /**
     * Get the value property: The value to operate on.
     * 
     * @return the value value.
     */
    @Generated
    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeySignParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeySignParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeySignParameters.
     */
    @Generated
    public static KeySignParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonWebKeySignatureAlgorithm algorithm = null;
            byte[] value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    Base64Url valueHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder != null) {
                        value = valueHolder.decodedBytes();
                    }
                } else {
                    reader.skipChildren();
                }
            }
            return new KeySignParameters(algorithm, value);
        });
    }
}
