// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A condition to be satisfied for an action to be executed.
 */
@Fluent
public final class LifetimeActionsTrigger implements JsonSerializable<LifetimeActionsTrigger> {
    /*
     * Time after creation to attempt to rotate. It only applies to rotate. It will be in ISO 8601 duration format.
     * Example: 90 days : "P90D"
     */
    @Generated
    private String timeAfterCreate;

    /*
     * Time before expiry to attempt to rotate or notify. It will be in ISO 8601 duration format. Example: 90 days :
     * "P90D"
     */
    @Generated
    private String timeBeforeExpiry;

    /**
     * Creates an instance of LifetimeActionsTrigger class.
     */
    @Generated
    public LifetimeActionsTrigger() {
    }

    /**
     * Get the timeAfterCreate property: Time after creation to attempt to rotate. It only applies to rotate. It will be
     * in ISO 8601 duration format. Example: 90 days : "P90D".
     * 
     * @return the timeAfterCreate value.
     */
    @Generated
    public String getTimeAfterCreate() {
        return this.timeAfterCreate;
    }

    /**
     * Set the timeAfterCreate property: Time after creation to attempt to rotate. It only applies to rotate. It will be
     * in ISO 8601 duration format. Example: 90 days : "P90D".
     * 
     * @param timeAfterCreate the timeAfterCreate value to set.
     * @return the LifetimeActionsTrigger object itself.
     */
    @Generated
    public LifetimeActionsTrigger setTimeAfterCreate(String timeAfterCreate) {
        this.timeAfterCreate = timeAfterCreate;
        return this;
    }

    /**
     * Get the timeBeforeExpiry property: Time before expiry to attempt to rotate or notify. It will be in ISO 8601
     * duration format. Example: 90 days : "P90D".
     * 
     * @return the timeBeforeExpiry value.
     */
    @Generated
    public String getTimeBeforeExpiry() {
        return this.timeBeforeExpiry;
    }

    /**
     * Set the timeBeforeExpiry property: Time before expiry to attempt to rotate or notify. It will be in ISO 8601
     * duration format. Example: 90 days : "P90D".
     * 
     * @param timeBeforeExpiry the timeBeforeExpiry value to set.
     * @return the LifetimeActionsTrigger object itself.
     */
    @Generated
    public LifetimeActionsTrigger setTimeBeforeExpiry(String timeBeforeExpiry) {
        this.timeBeforeExpiry = timeBeforeExpiry;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeAfterCreate", this.timeAfterCreate);
        jsonWriter.writeStringField("timeBeforeExpiry", this.timeBeforeExpiry);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LifetimeActionsTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LifetimeActionsTrigger if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LifetimeActionsTrigger.
     */
    @Generated
    public static LifetimeActionsTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LifetimeActionsTrigger deserializedLifetimeActionsTrigger = new LifetimeActionsTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeAfterCreate".equals(fieldName)) {
                    deserializedLifetimeActionsTrigger.timeAfterCreate = reader.getString();
                } else if ("timeBeforeExpiry".equals(fieldName)) {
                    deserializedLifetimeActionsTrigger.timeBeforeExpiry = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLifetimeActionsTrigger;
        });
    }
}
