// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The get random bytes response object containing the bytes.
 */
@Immutable
public final class RandomBytes implements JsonSerializable<RandomBytes> {
    /*
     * The bytes encoded as a base64url string.
     */
    @Generated
    private final Base64Url value;

    /**
     * Creates an instance of RandomBytes class.
     * 
     * @param value the value value to set.
     */
    @Generated
    private RandomBytes(byte[] value) {
        if (value == null) {
            this.value = null;
        } else {
            this.value = Base64Url.encode(value);
        }
    }

    /**
     * Get the value property: The bytes encoded as a base64url string.
     * 
     * @return the value value.
     */
    @Generated
    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RandomBytes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RandomBytes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RandomBytes.
     */
    @Generated
    public static RandomBytes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            byte[] value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    Base64Url valueHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder != null) {
                        value = valueHolder.decodedBytes();
                    }
                } else {
                    reader.skipChildren();
                }
            }
            return new RandomBytes(value);
        });
    }
}
