// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.security.keyvault.keys.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The release result, containing the released key.
 */
@Immutable
public final class ReleaseKeyResult implements JsonSerializable<ReleaseKeyResult> {

    /*
     * A signed object containing the released key.
     */
    @Generated
    private String value;

    /**
     * Creates an instance of ReleaseKeyResult.
     */
    @Generated
    public ReleaseKeyResult() {
    }

    /**
     * A signed object containing the released key.
     *
     * @return The released key.
     */
    @Generated
    public String getValue() {
        return this.value;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReleaseKeyResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReleaseKeyResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReleaseKeyResult.
     */
    @Generated
    public static ReleaseKeyResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReleaseKeyResult deserializedReleaseKeyResult = new ReleaseKeyResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedReleaseKeyResult.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedReleaseKeyResult;
        });
    }
}
