// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key restore parameters.
 */
@Immutable
public final class KeyRestoreParameters implements JsonSerializable<KeyRestoreParameters> {
    /*
     * The backup blob associated with a key bundle.
     */
    @Generated
    private final Base64Url keyBundleBackup;

    /**
     * Creates an instance of KeyRestoreParameters class.
     * 
     * @param keyBundleBackup the keyBundleBackup value to set.
     */
    @Generated
    public KeyRestoreParameters(byte[] keyBundleBackup) {
        if (keyBundleBackup == null) {
            this.keyBundleBackup = null;
        } else {
            this.keyBundleBackup = Base64Url.encode(keyBundleBackup);
        }
    }

    /**
     * Get the keyBundleBackup property: The backup blob associated with a key bundle.
     * 
     * @return the keyBundleBackup value.
     */
    @Generated
    public byte[] getKeyBundleBackup() {
        if (this.keyBundleBackup == null) {
            return null;
        }
        return this.keyBundleBackup.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.keyBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyRestoreParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyRestoreParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyRestoreParameters.
     */
    @Generated
    public static KeyRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            byte[] keyBundleBackup = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    Base64Url keyBundleBackupHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (keyBundleBackupHolder != null) {
                        keyBundleBackup = keyBundleBackupHolder.decodedBytes();
                    }
                } else {
                    reader.skipChildren();
                }
            }
            return new KeyRestoreParameters(keyBundleBackup);
        });
    }
}
