// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * An algorithm used for encryption and decryption.
 */
public final class JsonWebKeyEncryptionAlgorithm extends ExpandableStringEnum<JsonWebKeyEncryptionAlgorithm> {
    /**
     * [Not recommended] RSAES using Optimal Asymmetric Encryption Padding (OAEP), as described in
     * https://tools.ietf.org/html/rfc3447, with the default parameters specified by RFC 3447 in Section A.2.1. Those
     * default parameters are using a hash function of SHA-1 and a mask generation function of MGF1 with SHA-1.
     * Microsoft recommends using RSA_OAEP_256 or stronger algorithms for enhanced security. Microsoft does *not*
     * recommend RSA_OAEP, which is included solely for backwards compatibility. RSA_OAEP utilizes SHA1, which has known
     * collision problems.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm RSA_OAEP = fromString("RSA-OAEP");

    /**
     * RSAES using Optimal Asymmetric Encryption Padding with a hash function of SHA-256 and a mask generation function
     * of MGF1 with SHA-256.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm RSA_OAEP256 = fromString("RSA-OAEP-256");

    /**
     * [Not recommended] RSAES-PKCS1-V1_5 key encryption, as described in https://tools.ietf.org/html/rfc3447. Microsoft
     * recommends using RSA_OAEP_256 or stronger algorithms for enhanced security. Microsoft does *not* recommend
     * RSA_1_5, which is included solely for backwards compatibility. Cryptographic standards no longer consider RSA
     * with the PKCS#1 v1.5 padding scheme secure for encryption.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm RSA1_5 = fromString("RSA1_5");

    /**
     * 128-bit AES-GCM.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A128_GCM = fromString("A128GCM");

    /**
     * 192-bit AES-GCM.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A192_GCM = fromString("A192GCM");

    /**
     * 256-bit AES-GCM.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A256_GCM = fromString("A256GCM");

    /**
     * 128-bit AES key wrap.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A128_KW = fromString("A128KW");

    /**
     * 192-bit AES key wrap.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A192_KW = fromString("A192KW");

    /**
     * 256-bit AES key wrap.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A256_KW = fromString("A256KW");

    /**
     * 128-bit AES-CBC.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A128_CBC = fromString("A128CBC");

    /**
     * 192-bit AES-CBC.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A192_CBC = fromString("A192CBC");

    /**
     * 256-bit AES-CBC.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A256_CBC = fromString("A256CBC");

    /**
     * 128-bit AES-CBC with PKCS padding.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A128_CBCPAD = fromString("A128CBCPAD");

    /**
     * 192-bit AES-CBC with PKCS padding.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A192_CBCPAD = fromString("A192CBCPAD");

    /**
     * 256-bit AES-CBC with PKCS padding.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm A256_CBCPAD = fromString("A256CBCPAD");

    /**
     * CKM AES key wrap.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm CKM_AES_KEY_WRAP = fromString("CKM_AES_KEY_WRAP");

    /**
     * CKM AES key wrap with padding.
     */
    @Generated
    public static final JsonWebKeyEncryptionAlgorithm CKM_AES_KEY_WRAP_PAD = fromString("CKM_AES_KEY_WRAP_PAD");

    /**
     * Creates a new instance of JsonWebKeyEncryptionAlgorithm value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public JsonWebKeyEncryptionAlgorithm() {
    }

    /**
     * Creates or finds a JsonWebKeyEncryptionAlgorithm from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JsonWebKeyEncryptionAlgorithm.
     */
    @Generated
    public static JsonWebKeyEncryptionAlgorithm fromString(String name) {
        return fromString(name, JsonWebKeyEncryptionAlgorithm.class);
    }

    /**
     * Gets known JsonWebKeyEncryptionAlgorithm values.
     * 
     * @return known JsonWebKeyEncryptionAlgorithm values.
     */
    @Generated
    public static Collection<JsonWebKeyEncryptionAlgorithm> values() {
        return values(JsonWebKeyEncryptionAlgorithm.class);
    }
}
