// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The key create parameters.
 */
@Fluent
public final class KeyCreateParameters implements JsonSerializable<KeyCreateParameters> {
    /*
     * The type of key to create. For valid values, see JsonWebKeyType.
     */
    @Generated
    private final KeyType kty;

    /*
     * The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    @Generated
    private Integer keySize;

    /*
     * The public exponent for a RSA key.
     */
    @Generated
    private Integer publicExponent;

    /*
     * Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     */
    @Generated
    private List<KeyOperation> keyOps;

    /*
     * The attributes of a key managed by the key vault service.
     */
    @Generated
    private KeyAttributes keyAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @Generated
    private KeyCurveName curve;

    /*
     * The policy rules under which the key can be exported.
     */
    @Generated
    private KeyReleasePolicy releasePolicy;

    /**
     * Creates an instance of KeyCreateParameters class.
     * 
     * @param kty the kty value to set.
     */
    @Generated
    public KeyCreateParameters(KeyType kty) {
        this.kty = kty;
    }

    /**
     * Get the kty property: The type of key to create. For valid values, see JsonWebKeyType.
     * 
     * @return the kty value.
     */
    @Generated
    public KeyType getKty() {
        return this.kty;
    }

    /**
     * Get the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * 
     * @return the keySize value.
     */
    @Generated
    public Integer getKeySize() {
        return this.keySize;
    }

    /**
     * Set the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * 
     * @param keySize the keySize value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the publicExponent property: The public exponent for a RSA key.
     * 
     * @return the publicExponent value.
     */
    @Generated
    public Integer getPublicExponent() {
        return this.publicExponent;
    }

    /**
     * Set the publicExponent property: The public exponent for a RSA key.
     * 
     * @param publicExponent the publicExponent value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setPublicExponent(Integer publicExponent) {
        this.publicExponent = publicExponent;
        return this;
    }

    /**
     * Get the keyOps property: Json web key operations. For more information on possible key operations, see
     * JsonWebKeyOperation.
     * 
     * @return the keyOps value.
     */
    @Generated
    public List<KeyOperation> getKeyOps() {
        return this.keyOps;
    }

    /**
     * Set the keyOps property: Json web key operations. For more information on possible key operations, see
     * JsonWebKeyOperation.
     * 
     * @param keyOps the keyOps value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    /**
     * Get the keyAttributes property: The attributes of a key managed by the key vault service.
     * 
     * @return the keyAttributes value.
     */
    @Generated
    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    /**
     * Set the keyAttributes property: The attributes of a key managed by the key vault service.
     * 
     * @param keyAttributes the keyAttributes value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the curve property: Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     * 
     * @return the curve value.
     */
    @Generated
    public KeyCurveName getCurve() {
        return this.curve;
    }

    /**
     * Set the curve property: Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     * 
     * @param curve the curve value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setCurve(KeyCurveName curve) {
        this.curve = curve;
        return this;
    }

    /**
     * Get the releasePolicy property: The policy rules under which the key can be exported.
     * 
     * @return the releasePolicy value.
     */
    @Generated
    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    /**
     * Set the releasePolicy property: The policy rules under which the key can be exported.
     * 
     * @param releasePolicy the releasePolicy value to set.
     * @return the KeyCreateParameters object itself.
     */
    @Generated
    public KeyCreateParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kty", this.kty == null ? null : this.kty.toString());
        jsonWriter.writeNumberField("key_size", this.keySize);
        jsonWriter.writeNumberField("public_exponent", this.publicExponent);
        jsonWriter.writeArrayField("key_ops", this.keyOps,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("crv", this.curve == null ? null : this.curve.toString());
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyCreateParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyCreateParameters.
     */
    @Generated
    public static KeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyType kty = null;
            Integer keySize = null;
            Integer publicExponent = null;
            List<KeyOperation> keyOps = null;
            KeyAttributes keyAttributes = null;
            Map<String, String> tags = null;
            KeyCurveName curve = null;
            KeyReleasePolicy releasePolicy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kty".equals(fieldName)) {
                    kty = KeyType.fromString(reader.getString());
                } else if ("key_size".equals(fieldName)) {
                    keySize = reader.getNullable(JsonReader::getInt);
                } else if ("public_exponent".equals(fieldName)) {
                    publicExponent = reader.getNullable(JsonReader::getInt);
                } else if ("key_ops".equals(fieldName)) {
                    keyOps = reader.readArray(reader1 -> KeyOperation.fromString(reader1.getString()));
                } else if ("attributes".equals(fieldName)) {
                    keyAttributes = KeyAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else if ("crv".equals(fieldName)) {
                    curve = KeyCurveName.fromString(reader.getString());
                } else if ("release_policy".equals(fieldName)) {
                    releasePolicy = KeyReleasePolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            KeyCreateParameters deserializedKeyCreateParameters = new KeyCreateParameters(kty);
            deserializedKeyCreateParameters.keySize = keySize;
            deserializedKeyCreateParameters.publicExponent = publicExponent;
            deserializedKeyCreateParameters.keyOps = keyOps;
            deserializedKeyCreateParameters.keyAttributes = keyAttributes;
            deserializedKeyCreateParameters.tags = tags;
            deserializedKeyCreateParameters.curve = curve;
            deserializedKeyCreateParameters.releasePolicy = releasePolicy;

            return deserializedKeyCreateParameters;
        });
    }
}
