// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The key import parameters.
 */
@Fluent
public final class KeyImportParameters implements JsonSerializable<KeyImportParameters> {
    /*
     * Whether to import as a hardware key (HSM) or software key.
     */
    @Generated
    private Boolean hsm;

    /*
     * The Json web key
     */
    @Generated
    private final JsonWebKey key;

    /*
     * The key management attributes.
     */
    @Generated
    private KeyAttributes keyAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * The policy rules under which the key can be exported.
     */
    @Generated
    private KeyReleasePolicy releasePolicy;

    /**
     * Creates an instance of KeyImportParameters class.
     * 
     * @param key the key value to set.
     */
    @Generated
    public KeyImportParameters(JsonWebKey key) {
        this.key = key;
    }

    /**
     * Get the hsm property: Whether to import as a hardware key (HSM) or software key.
     * 
     * @return the hsm value.
     */
    @Generated
    public Boolean isHsm() {
        return this.hsm;
    }

    /**
     * Set the hsm property: Whether to import as a hardware key (HSM) or software key.
     * 
     * @param hsm the hsm value to set.
     * @return the KeyImportParameters object itself.
     */
    @Generated
    public KeyImportParameters setHsm(Boolean hsm) {
        this.hsm = hsm;
        return this;
    }

    /**
     * Get the key property: The Json web key.
     * 
     * @return the key value.
     */
    @Generated
    public JsonWebKey getKey() {
        return this.key;
    }

    /**
     * Get the keyAttributes property: The key management attributes.
     * 
     * @return the keyAttributes value.
     */
    @Generated
    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    /**
     * Set the keyAttributes property: The key management attributes.
     * 
     * @param keyAttributes the keyAttributes value to set.
     * @return the KeyImportParameters object itself.
     */
    @Generated
    public KeyImportParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the KeyImportParameters object itself.
     */
    @Generated
    public KeyImportParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the releasePolicy property: The policy rules under which the key can be exported.
     * 
     * @return the releasePolicy value.
     */
    @Generated
    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    /**
     * Set the releasePolicy property: The policy rules under which the key can be exported.
     * 
     * @param releasePolicy the releasePolicy value to set.
     * @return the KeyImportParameters object itself.
     */
    @Generated
    public KeyImportParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeBooleanField("Hsm", this.hsm);
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyImportParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyImportParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyImportParameters.
     */
    @Generated
    public static KeyImportParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonWebKey key = null;
            Boolean hsm = null;
            KeyAttributes keyAttributes = null;
            Map<String, String> tags = null;
            KeyReleasePolicy releasePolicy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    key = JsonWebKey.fromJson(reader);
                } else if ("Hsm".equals(fieldName)) {
                    hsm = reader.getNullable(JsonReader::getBoolean);
                } else if ("attributes".equals(fieldName)) {
                    keyAttributes = KeyAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else if ("release_policy".equals(fieldName)) {
                    releasePolicy = KeyReleasePolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            KeyImportParameters deserializedKeyImportParameters = new KeyImportParameters(key);
            deserializedKeyImportParameters.hsm = hsm;
            deserializedKeyImportParameters.keyAttributes = keyAttributes;
            deserializedKeyImportParameters.tags = tags;
            deserializedKeyImportParameters.releasePolicy = releasePolicy;

            return deserializedKeyImportParameters;
        });
    }
}
