// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The key item containing key metadata.
 */
@Immutable
public final class KeyItem implements JsonSerializable<KeyItem> {
    /*
     * Key identifier.
     */
    @Generated
    private String kid;

    /*
     * The key management attributes.
     */
    @Generated
    private KeyAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be
     * true.
     */
    @Generated
    private Boolean managed;

    /**
     * Creates an instance of KeyItem class.
     */
    @Generated
    private KeyItem() {
    }

    /**
     * Get the kid property: Key identifier.
     * 
     * @return the kid value.
     */
    @Generated
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the attributes property: The key management attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the managed property: True if the key's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     * 
     * @return the managed value.
     */
    @Generated
    public Boolean isManaged() {
        return this.managed;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyItem if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the KeyItem.
     */
    @Generated
    public static KeyItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyItem deserializedKeyItem = new KeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kid".equals(fieldName)) {
                    deserializedKeyItem.kid = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedKeyItem.attributes = KeyAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyItem.tags = tags;
                } else if ("managed".equals(fieldName)) {
                    deserializedKeyItem.managed = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyItem;
        });
    }
}
