// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The key operation result.
 */
@Immutable
public final class KeyOperationResult implements JsonSerializable<KeyOperationResult> {
    /*
     * Key identifier
     */
    @Generated
    private String kid;

    /*
     * The result of the operation.
     */
    @Generated
    private Base64Url result;

    /*
     * Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     */
    @Generated
    private Base64Url iv;

    /*
     * The tag to authenticate when performing decryption with an authenticated algorithm.
     */
    @Generated
    private Base64Url authenticationTag;

    /*
     * Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     */
    @Generated
    private Base64Url additionalAuthenticatedData;

    /**
     * Creates an instance of KeyOperationResult class.
     */
    @Generated
    private KeyOperationResult() {
    }

    /**
     * Get the kid property: Key identifier.
     * 
     * @return the kid value.
     */
    @Generated
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the result property: The result of the operation.
     * 
     * @return the result value.
     */
    @Generated
    public byte[] getResult() {
        if (this.result == null) {
            return null;
        }
        return this.result.decodedBytes();
    }

    /**
     * Get the iv property: Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * 
     * @return the iv value.
     */
    @Generated
    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    /**
     * Get the authenticationTag property: The tag to authenticate when performing decryption with an authenticated
     * algorithm.
     * 
     * @return the authenticationTag value.
     */
    @Generated
    public byte[] getAuthenticationTag() {
        if (this.authenticationTag == null) {
            return null;
        }
        return this.authenticationTag.decodedBytes();
    }

    /**
     * Get the additionalAuthenticatedData property: Additional data to authenticate but not encrypt/decrypt when using
     * authenticated crypto algorithms.
     * 
     * @return the additionalAuthenticatedData value.
     */
    @Generated
    public byte[] getAdditionalAuthenticatedData() {
        if (this.additionalAuthenticatedData == null) {
            return null;
        }
        return this.additionalAuthenticatedData.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyOperationResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyOperationResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyOperationResult.
     */
    @Generated
    public static KeyOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyOperationResult deserializedKeyOperationResult = new KeyOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kid".equals(fieldName)) {
                    deserializedKeyOperationResult.kid = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedKeyOperationResult.result
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("iv".equals(fieldName)) {
                    deserializedKeyOperationResult.iv
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("tag".equals(fieldName)) {
                    deserializedKeyOperationResult.authenticationTag
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("aad".equals(fieldName)) {
                    deserializedKeyOperationResult.additionalAuthenticatedData
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyOperationResult;
        });
    }
}
