// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key operations parameters.
 */
@Fluent
public final class KeyOperationsParameters implements JsonSerializable<KeyOperationsParameters> {
    /*
     * algorithm identifier
     */
    @Generated
    private final JsonWebKeyEncryptionAlgorithm algorithm;

    /*
     * The value to operate on.
     */
    @Generated
    private final Base64Url value;

    /*
     * Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     */
    @Generated
    private Base64Url iv;

    /*
     * Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     */
    @Generated
    private Base64Url aad;

    /*
     * The tag to authenticate when performing decryption with an authenticated algorithm.
     */
    @Generated
    private Base64Url tag;

    /**
     * Creates an instance of KeyOperationsParameters class.
     * 
     * @param algorithm the algorithm value to set.
     * @param value the value value to set.
     */
    @Generated
    public KeyOperationsParameters(JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        if (value == null) {
            this.value = null;
        } else {
            this.value = Base64Url.encode(value);
        }
    }

    /**
     * Get the algorithm property: algorithm identifier.
     * 
     * @return the algorithm value.
     */
    @Generated
    public JsonWebKeyEncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    /**
     * Get the value property: The value to operate on.
     * 
     * @return the value value.
     */
    @Generated
    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    /**
     * Get the iv property: Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * 
     * @return the iv value.
     */
    @Generated
    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    /**
     * Set the iv property: Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * 
     * @param iv the iv value to set.
     * @return the KeyOperationsParameters object itself.
     */
    @Generated
    public KeyOperationsParameters setIv(byte[] iv) {
        if (iv == null) {
            this.iv = null;
        } else {
            this.iv = Base64Url.encode(CoreUtils.clone(iv));
        }
        return this;
    }

    /**
     * Get the aad property: Additional data to authenticate but not encrypt/decrypt when using authenticated crypto
     * algorithms.
     * 
     * @return the aad value.
     */
    @Generated
    public byte[] getAad() {
        if (this.aad == null) {
            return null;
        }
        return this.aad.decodedBytes();
    }

    /**
     * Set the aad property: Additional data to authenticate but not encrypt/decrypt when using authenticated crypto
     * algorithms.
     * 
     * @param aad the aad value to set.
     * @return the KeyOperationsParameters object itself.
     */
    @Generated
    public KeyOperationsParameters setAad(byte[] aad) {
        if (aad == null) {
            this.aad = null;
        } else {
            this.aad = Base64Url.encode(CoreUtils.clone(aad));
        }
        return this;
    }

    /**
     * Get the tag property: The tag to authenticate when performing decryption with an authenticated algorithm.
     * 
     * @return the tag value.
     */
    @Generated
    public byte[] getTag() {
        if (this.tag == null) {
            return null;
        }
        return this.tag.decodedBytes();
    }

    /**
     * Set the tag property: The tag to authenticate when performing decryption with an authenticated algorithm.
     * 
     * @param tag the tag value to set.
     * @return the KeyOperationsParameters object itself.
     */
    @Generated
    public KeyOperationsParameters setTag(byte[] tag) {
        if (tag == null) {
            this.tag = null;
        } else {
            this.tag = Base64Url.encode(CoreUtils.clone(tag));
        }
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        jsonWriter.writeStringField("iv", Objects.toString(this.iv, null));
        jsonWriter.writeStringField("aad", Objects.toString(this.aad, null));
        jsonWriter.writeStringField("tag", Objects.toString(this.tag, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyOperationsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyOperationsParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyOperationsParameters.
     */
    @Generated
    public static KeyOperationsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonWebKeyEncryptionAlgorithm algorithm = null;
            byte[] value = null;
            Base64Url iv = null;
            Base64Url aad = null;
            Base64Url tag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeyEncryptionAlgorithm.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    Base64Url valueHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder != null) {
                        value = valueHolder.decodedBytes();
                    }
                } else if ("iv".equals(fieldName)) {
                    iv = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("aad".equals(fieldName)) {
                    aad = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("tag".equals(fieldName)) {
                    tag = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            KeyOperationsParameters deserializedKeyOperationsParameters = new KeyOperationsParameters(algorithm, value);
            deserializedKeyOperationsParameters.iv = iv;
            deserializedKeyOperationsParameters.aad = aad;
            deserializedKeyOperationsParameters.tag = tag;

            return deserializedKeyOperationsParameters;
        });
    }
}
