// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key verify parameters.
 */
@Immutable
public final class KeyVerifyParameters implements JsonSerializable<KeyVerifyParameters> {
    /*
     * The signing/verification algorithm. For more information on possible algorithm types, see
     * JsonWebKeySignatureAlgorithm.
     */
    @Generated
    private final JsonWebKeySignatureAlgorithm algorithm;

    /*
     * The digest used for signing.
     */
    @Generated
    private final Base64Url digest;

    /*
     * The signature to be verified.
     */
    @Generated
    private final Base64Url signature;

    /**
     * Creates an instance of KeyVerifyParameters class.
     * 
     * @param algorithm the algorithm value to set.
     * @param digest the digest value to set.
     * @param signature the signature value to set.
     */
    @Generated
    public KeyVerifyParameters(JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        this.algorithm = algorithm;
        if (digest == null) {
            this.digest = null;
        } else {
            this.digest = Base64Url.encode(digest);
        }
        if (signature == null) {
            this.signature = null;
        } else {
            this.signature = Base64Url.encode(signature);
        }
    }

    /**
     * Get the algorithm property: The signing/verification algorithm. For more information on possible algorithm types,
     * see JsonWebKeySignatureAlgorithm.
     * 
     * @return the algorithm value.
     */
    @Generated
    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    /**
     * Get the digest property: The digest used for signing.
     * 
     * @return the digest value.
     */
    @Generated
    public byte[] getDigest() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.decodedBytes();
    }

    /**
     * Get the signature property: The signature to be verified.
     * 
     * @return the signature value.
     */
    @Generated
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("digest", Objects.toString(this.digest, null));
        jsonWriter.writeStringField("value", Objects.toString(this.signature, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVerifyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVerifyParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVerifyParameters.
     */
    @Generated
    public static KeyVerifyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonWebKeySignatureAlgorithm algorithm = null;
            byte[] digest = null;
            byte[] signature = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                } else if ("digest".equals(fieldName)) {
                    Base64Url digestHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (digestHolder != null) {
                        digest = digestHolder.decodedBytes();
                    }
                } else if ("value".equals(fieldName)) {
                    Base64Url signatureHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (signatureHolder != null) {
                        signature = signatureHolder.decodedBytes();
                    }
                } else {
                    reader.skipChildren();
                }
            }
            return new KeyVerifyParameters(algorithm, digest, signature);
        });
    }
}
