// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the KeyClient type.
 */
public final class KeyClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final KeyClientService service;

    /**
     */
    private final String vaultBaseUrl;

    /**
     * Gets.
     * 
     * @return the vaultBaseUrl value.
     */
    public String getVaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    /**
     * Service version.
     */
    private final KeyServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public KeyServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of KeyClient client.
     * 
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public KeyClientImpl(String vaultBaseUrl, KeyServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    /**
     * Initializes an instance of KeyClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public KeyClientImpl(HttpPipeline httpPipeline, String vaultBaseUrl, KeyServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    /**
     * Initializes an instance of KeyClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public KeyClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String vaultBaseUrl,
        KeyServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.vaultBaseUrl = vaultBaseUrl;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(KeyClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for KeyClient to be used by the proxy service to perform REST calls.
     */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "KeyClient")
    public interface KeyClientService {
        @Post("/keys/{key-name}/create")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/create")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/rotate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> rotateKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/rotate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> rotateKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Put("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> importKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Put("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> importKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Delete("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Patch("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Patch("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeyVersions(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeyVersionsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeys(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeysSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> backupKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> backupKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/keys/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> restoreKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> restoreKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> encrypt(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> encryptSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> decrypt(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> decryptSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> sign(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> signSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> verify(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> verifySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> wrapKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> wrapKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> unwrapKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> unwrapKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/release")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> release(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/keys/{key-name}/{key-version}/release")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> releaseSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Get("/deletedkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedKeys(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/deletedkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedKeysSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/deletedkeys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/deletedkeys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/deletedkeys/{key-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> purgeDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/deletedkeys/{key-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> purgeDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/deletedkeys/{key-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> recoverDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/deletedkeys/{key-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> recoverDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeyRotationPolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeyRotationPolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Put("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateKeyRotationPolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData keyRotationPolicy, RequestOptions requestOptions,
            Context context);

        @Put("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateKeyRotationPolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData keyRotationPolicy, RequestOptions requestOptions,
            Context context);

        @Post("/rng")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getRandomBytes(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/rng")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getRandomBytesSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/{key-version}/attestation")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeyAttestation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/keys/{key-name}/{key-version}/attestation")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeyAttestationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("key-name") String keyName,
            @PathParam("key-version") String keyVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeyVersionsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeyVersionsNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getKeysNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getKeysNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedKeysNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedKeysNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * 
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists,
     * Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Required)
     *     key_size: Integer (Optional)
     *     public_exponent: Integer (Optional)
     *     key_ops (Optional): [
     *         String(encrypt/decrypt/sign/verify/wrapKey/unwrapKey/import/export) (Optional)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     * provide may be copied globally for the purpose of running the service. The value provided should not include
     * personally identifiable or sensitive information.
     * @param parameters The parameters to create a key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createKeyWithResponseAsync(String keyName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * 
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists,
     * Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Required)
     *     key_size: Integer (Optional)
     *     public_exponent: Integer (Optional)
     *     key_ops (Optional): [
     *         String(encrypt/decrypt/sign/verify/wrapKey/unwrapKey/import/export) (Optional)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     * provide may be copied globally for the purpose of running the service. The value provided should not include
     * personally identifiable or sensitive information.
     * @param parameters The parameters to create a key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createKeyWithResponse(String keyName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     * 
     * The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> rotateKeyWithResponseAsync(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.rotateKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     * 
     * The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> rotateKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.rotateKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * 
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     Hsm: Boolean (Optional)
     *     key (Required): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     * the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to import a key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> importKeyWithResponseAsync(String keyName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.importKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * 
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     Hsm: Boolean (Optional)
     *     key (Required): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     * the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to import a key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> importKeyWithResponse(String keyName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.importKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * 
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to delete.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteKeyWithResponseAsync(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * 
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to delete.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, accept,
            requestOptions, Context.NONE);
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     * 
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material
     * of a key itself cannot be changed. This operation requires the keys/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key_ops (Optional): [
     *         String(encrypt/decrypt/sign/verify/wrapKey/unwrapKey/import/export) (Optional)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param parameters The parameters of the key to update.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateKeyWithResponseAsync(String keyName, String keyVersion,
        BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateKey(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     * 
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material
     * of a key itself cannot be changed. This operation requires the keys/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key_ops (Optional): [
     *         String(encrypt/decrypt/sign/verify/wrapKey/unwrapKey/import/export) (Optional)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param parameters The parameters of the key to update.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateKeyWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Gets the public part of a stored key.
     * 
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is
     * released in the response. This operation requires the keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     * optional. If not specified, the latest version of the key is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a stored key.
     * 
     * The get key operation is applicable to all key types along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getKeyWithResponseAsync(String keyName, String keyVersion,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, keyVersion, accept, requestOptions, context));
    }

    /**
     * Gets the public part of a stored key.
     * 
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is
     * released in the response. This operation requires the keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     * optional. If not specified, the latest version of the key is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a stored key.
     * 
     * The get key operation is applicable to all key types along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getKeyWithResponse(String keyName, String keyVersion, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list
     * permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getKeyVersionsSinglePageAsync(String keyName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getKeyVersions(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list
     * permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getKeyVersionsAsync(String keyName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getKeyVersionsSinglePageAsync(keyName, requestOptions),
            nextLink -> getKeyVersionsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list
     * permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getKeyVersionsSinglePage(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getKeyVersionsSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list
     * permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getKeyVersions(String keyName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getKeyVersionsSinglePage(keyName, requestOptions),
            nextLink -> getKeyVersionsNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * List keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored
     * key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and
     * tags are provided in the response. Individual versions of a key are not listed in the response. This operation
     * requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getKeysSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getKeys(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored
     * key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and
     * tags are provided in the response. Individual versions of a key are not listed in the response. This operation
     * requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getKeysAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getKeysSinglePageAsync(requestOptions),
            nextLink -> getKeysNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored
     * key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and
     * tags are provided in the response. Individual versions of a key are not listed in the response. This operation
     * requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getKeysSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getKeysSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored
     * key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and
     * tags are provided in the response. Individual versions of a key are not listed in the response. This operation
     * requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getKeys(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getKeysSinglePage(requestOptions),
            nextLink -> getKeysNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * 
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the backup key result, containing the backup blob along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> backupKeyWithResponseAsync(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.backupKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * 
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the backup key result, containing the backup blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> backupKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.backupKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Restores a backed up key to a vault.
     * 
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param parameters The parameters to restore the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> restoreKeyWithResponseAsync(BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.restoreKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Restores a backed up key to a vault.
     * 
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param parameters The parameters to restore the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> restoreKeyWithResponse(BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.restoreKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), contentType,
            accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * 
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key
     * Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on
     * the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the encryption operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> encryptWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.encrypt(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * 
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key
     * Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on
     * the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the encryption operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> encryptWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.encryptSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Decrypts a single block of encrypted data.
     * 
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://learn.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the decryption operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> decryptWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.decrypt(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Decrypts a single block of encrypted data.
     * 
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://learn.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the decryption operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> decryptWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.decryptSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Creates a signature from a digest using the specified key.
     * 
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation
     * uses the private portion of the key. This operation requires the keys/sign permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(PS256/PS384/PS512/RS256/RS384/RS512/HS256/HS384/HS512/RSNULL/ES256/ES384/ES512/ES256K) (Required)
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the signing operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> signWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.sign(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
                keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Creates a signature from a digest using the specified key.
     * 
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation
     * uses the private portion of the key. This operation requires the keys/sign permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(PS256/PS384/PS512/RS256/RS384/RS512/HS256/HS384/HS512/RSNULL/ES256/ES384/ES512/ES256K) (Required)
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the signing operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> signWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.signSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Verifies a signature using a specified key.
     * 
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary
     * for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public
     * portion of the key but this operation is supported as a convenience for callers that only have a key-reference
     * and not the public portion of the key. This operation requires the keys/verify permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(PS256/PS384/PS512/RS256/RS384/RS512/HS256/HS384/HS512/RSNULL/ES256/ES384/ES512/ES256K) (Required)
     *     digest: Base64Url (Required)
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for verify operations.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key verify result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> verifyWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.verify(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Verifies a signature using a specified key.
     * 
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary
     * for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public
     * portion of the key but this operation is supported as a convenience for callers that only have a key-reference
     * and not the public portion of the key. This operation requires the keys/verify permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(PS256/PS384/PS512/RS256/RS384/RS512/HS256/HS384/HS512/RSNULL/ES256/ES384/ES512/ES256K) (Required)
     *     digest: Base64Url (Required)
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for verify operations.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key verify result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> verifyWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.verifySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Wraps a symmetric key using a specified key.
     * 
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for wrap operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> wrapKeyWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.wrapKey(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Wraps a symmetric key using a specified key.
     * 
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for wrap operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> wrapKeyWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.wrapKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * 
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation
     * is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in
     * Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the key operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> unwrapKeyWithResponseAsync(String keyName, String keyVersion,
        BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.unwrapKey(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * 
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation
     * is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in
     * Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     alg: String(RSA-OAEP/RSA-OAEP-256/RSA1_5/A128GCM/A192GCM/A256GCM/A128KW/A192KW/A256KW/A128CBC/A192CBC/A256CBC/A128CBCPAD/A192CBCPAD/A256CBCPAD/CKM_AES_KEY_WRAP/CKM_AES_KEY_WRAP_PAD) (Required)
     *     value: Base64Url (Required)
     *     iv: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     value: Base64Url (Optional)
     *     iv: Base64Url (Optional)
     *     tag: Base64Url (Optional)
     *     aad: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param parameters The parameters for the key operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> unwrapKeyWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.unwrapKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Releases a key.
     * 
     * The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     target: String (Required)
     *     nonce: String (Optional)
     *     enc: String(CKM_RSA_AES_KEY_WRAP/RSA_AES_KEY_WRAP_256/RSA_AES_KEY_WRAP_384) (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param parameters The parameters for the key release operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the release result, containing the released key along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> releaseWithResponseAsync(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.release(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, keyVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Releases a key.
     * 
     * The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     target: String (Required)
     *     nonce: String (Optional)
     *     enc: String(CKM_RSA_AES_KEY_WRAP/RSA_AES_KEY_WRAP_256/RSA_AES_KEY_WRAP_384) (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param parameters The parameters for the key release operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the release result, containing the released key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> releaseWithResponse(String keyName, String keyVersion, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.releaseSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, keyVersion,
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedKeysSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeletedKeys(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getDeletedKeysAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getDeletedKeysSinglePageAsync(requestOptions),
            nextLink -> getDeletedKeysNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedKeysSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getDeletedKeysSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getDeletedKeys(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getDeletedKeysSinglePage(requestOptions),
            nextLink -> getDeletedKeysNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets the public part of a deleted key.
     * 
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on
     * any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a deleted key.
     * 
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeletedKeyWithResponseAsync(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getDeletedKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Gets the public part of a deleted key.
     * 
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on
     * any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a deleted key.
     * 
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeletedKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getDeletedKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Permanently deletes the specified key.
     * 
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/purge permission.
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.purgeDeletedKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Permanently deletes the specified key.
     * 
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/purge permission.
     * 
     * @param keyName The name of the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.purgeDeletedKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Recovers the deleted key to its latest version.
     * 
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the
     * deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the deleted key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> recoverDeletedKeyWithResponseAsync(String keyName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.recoverDeletedKey(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Recovers the deleted key to its latest version.
     * 
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the
     * deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the deleted key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> recoverDeletedKeyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.recoverDeletedKeySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Lists the policy for a key.
     * 
     * The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key in a given key vault.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getKeyRotationPolicyWithResponseAsync(String keyName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getKeyRotationPolicy(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, accept, requestOptions, context));
    }

    /**
     * Lists the policy for a key.
     * 
     * The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key in a given key vault.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getKeyRotationPolicyWithResponse(String keyName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getKeyRotationPolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Updates the rotation policy for a key.
     * 
     * Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateKeyRotationPolicyWithResponseAsync(String keyName,
        BinaryData keyRotationPolicy, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.updateKeyRotationPolicy(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                keyName, contentType, accept, keyRotationPolicy, requestOptions, context));
    }

    /**
     * Updates the rotation policy for a key.
     * 
     * Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     lifetimeActions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 timeAfterCreate: String (Optional)
     *                 timeBeforeExpiry: String (Optional)
     *             }
     *             action (Optional): {
     *                 type: String(Rotate/Notify) (Optional)
     *             }
     *         }
     *     ]
     *     attributes (Optional): {
     *         expiryTime: String (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateKeyRotationPolicyWithResponse(String keyName, BinaryData keyRotationPolicy,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateKeyRotationPolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            keyName, contentType, accept, keyRotationPolicy, requestOptions, Context.NONE);
    }

    /**
     * Get the requested number of bytes containing random values.
     * 
     * Get the requested number of bytes containing random values from a managed HSM.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     count: int (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * @param parameters The request object to get random bytes.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the requested number of bytes containing random values.
     * 
     * Get the requested number of bytes containing random values from a managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRandomBytesWithResponseAsync(BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getRandomBytes(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Get the requested number of bytes containing random values.
     * 
     * Get the requested number of bytes containing random values from a managed HSM.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     count: int (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * @param parameters The request object to get random bytes.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the requested number of bytes containing random values.
     * 
     * Get the requested number of bytes containing random values from a managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getRandomBytesWithResponse(BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.getRandomBytesSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), contentType,
            accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Gets the public part of a stored key along with its attestation blob.
     * 
     * The get key attestation operation returns the key along with its attestation blob. This operation requires the
     * keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to retrieve attestation for.
     * @param keyVersion Adding the version parameter retrieves attestation blob for specific version of a key. This URI
     * fragment is optional. If not specified, the latest version of the key attestation blob is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a stored key along with its attestation blob.
     * 
     * The get key attestation operation returns the key along with its attestation blob along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getKeyAttestationWithResponseAsync(String keyName, String keyVersion,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getKeyAttestation(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), keyName, keyVersion, accept, requestOptions, context));
    }

    /**
     * Gets the public part of a stored key along with its attestation blob.
     * 
     * The get key attestation operation returns the key along with its attestation blob. This operation requires the
     * keys/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     key (Optional): {
     *         kid: String (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_ops (Optional): [
     *             String (Optional)
     *         ]
     *         n: Base64Url (Optional)
     *         e: Base64Url (Optional)
     *         d: Base64Url (Optional)
     *         dp: Base64Url (Optional)
     *         dq: Base64Url (Optional)
     *         qi: Base64Url (Optional)
     *         p: Base64Url (Optional)
     *         q: Base64Url (Optional)
     *         k: Base64Url (Optional)
     *         key_hsm: Base64Url (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         x: Base64Url (Optional)
     *         y: Base64Url (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     release_policy (Optional): {
     *         contentType: String (Optional)
     *         immutable: Boolean (Optional)
     *         data: Base64Url (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param keyName The name of the key to retrieve attestation for.
     * @param keyVersion Adding the version parameter retrieves attestation blob for specific version of a key. This URI
     * fragment is optional. If not specified, the latest version of the key attestation blob is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the public part of a stored key along with its attestation blob.
     * 
     * The get key attestation operation returns the key along with its attestation blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getKeyAttestationWithResponse(String keyName, String keyVersion,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getKeyAttestationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName,
            keyVersion, accept, requestOptions, Context.NONE);
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getKeyVersionsNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getKeyVersionsNext(nextLink, this.getVaultBaseUrl(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getKeyVersionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.getKeyVersionsNextSync(nextLink, this.getVaultBaseUrl(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List keys in the specified vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getKeysNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getKeysNext(nextLink, this.getVaultBaseUrl(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List keys in the specified vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getKeysNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.getKeysNextSync(nextLink, this.getVaultBaseUrl(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedKeysNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getDeletedKeysNext(nextLink, this.getVaultBaseUrl(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Lists the deleted keys in the specified vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kid: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         exportable: Boolean (Optional)
     *         hsmPlatform: String (Optional)
     *         attestation (Optional): {
     *             certificatePemFile: Base64Url (Optional)
     *             privateKeyAttestation: Base64Url (Optional)
     *             publicKeyAttestation: Base64Url (Optional)
     *             version: String (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     managed: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedKeysNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.getDeletedKeysNextSync(nextLink, this.getVaultBaseUrl(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
