// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import java.io.IOException;

/**
 * The release key parameters.
 */
@Fluent
public final class KeyReleaseParameters implements JsonSerializable<KeyReleaseParameters> {
    /*
     * The attestation assertion for the target of the key release.
     */
    @Generated
    private final String targetAttestationToken;

    /*
     * A client provided nonce for freshness.
     */
    @Generated
    private String nonce;

    /*
     * The encryption algorithm to use to protected the exported key material
     */
    @Generated
    private KeyExportEncryptionAlgorithm enc;

    /**
     * Creates an instance of KeyReleaseParameters class.
     * 
     * @param targetAttestationToken the targetAttestationToken value to set.
     */
    @Generated
    public KeyReleaseParameters(String targetAttestationToken) {
        this.targetAttestationToken = targetAttestationToken;
    }

    /**
     * Get the targetAttestationToken property: The attestation assertion for the target of the key release.
     * 
     * @return the targetAttestationToken value.
     */
    @Generated
    public String getTargetAttestationToken() {
        return this.targetAttestationToken;
    }

    /**
     * Get the nonce property: A client provided nonce for freshness.
     * 
     * @return the nonce value.
     */
    @Generated
    public String getNonce() {
        return this.nonce;
    }

    /**
     * Set the nonce property: A client provided nonce for freshness.
     * 
     * @param nonce the nonce value to set.
     * @return the KeyReleaseParameters object itself.
     */
    @Generated
    public KeyReleaseParameters setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    /**
     * Get the enc property: The encryption algorithm to use to protected the exported key material.
     * 
     * @return the enc value.
     */
    @Generated
    public KeyExportEncryptionAlgorithm getEnc() {
        return this.enc;
    }

    /**
     * Set the enc property: The encryption algorithm to use to protected the exported key material.
     * 
     * @param enc the enc value to set.
     * @return the KeyReleaseParameters object itself.
     */
    @Generated
    public KeyReleaseParameters setEnc(KeyExportEncryptionAlgorithm enc) {
        this.enc = enc;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.targetAttestationToken);
        jsonWriter.writeStringField("nonce", this.nonce);
        jsonWriter.writeStringField("enc", this.enc == null ? null : this.enc.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyReleaseParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyReleaseParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyReleaseParameters.
     */
    @Generated
    public static KeyReleaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String targetAttestationToken = null;
            String nonce = null;
            KeyExportEncryptionAlgorithm enc = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("target".equals(fieldName)) {
                    targetAttestationToken = reader.getString();
                } else if ("nonce".equals(fieldName)) {
                    nonce = reader.getString();
                } else if ("enc".equals(fieldName)) {
                    enc = KeyExportEncryptionAlgorithm.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            KeyReleaseParameters deserializedKeyReleaseParameters = new KeyReleaseParameters(targetAttestationToken);
            deserializedKeyReleaseParameters.nonce = nonce;
            deserializedKeyReleaseParameters.enc = enc;

            return deserializedKeyReleaseParameters;
        });
    }
}
