// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.security.keyvault.keys.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key attestation information.
 */
@Immutable
public final class KeyAttestation implements JsonSerializable<KeyAttestation> {

    /*
     * A base64url-encoded string containing certificates in PEM format, used for attestation validation.
     */
    @Generated
    private Base64Url certificatePemFile;

    /*
     * The attestation blob bytes encoded as base64url string corresponding to a private key.
     */
    @Generated
    private Base64Url privateKeyAttestation;

    /*
     * The attestation blob bytes encoded as base64url string corresponding to a public key in case of asymmetric key.
     */
    @Generated
    private Base64Url publicKeyAttestation;

    /*
     * The version of the attestation.
     */
    @Generated
    private String version;

    /**
     * Creates an instance of KeyAttestation.
     */
    @Generated
    private KeyAttestation() {
    }

    /**
     * Get a base64url-encoded string containing certificates in PEM format, used for attestation validation.
     *
     * @return The certificate in PEM format.
     */
    @Generated
    public byte[] getCertificatePemFile() {
        if (this.certificatePemFile == null) {
            return null;
        }
        return this.certificatePemFile.decodedBytes();
    }

    /**
     * Get the attestation blob bytes encoded as base64url string corresponding to a private key.
     *
     * @return The attestation blob bytes for the private portion of the key.
     */
    @Generated
    public byte[] getPrivateKeyAttestation() {
        if (this.privateKeyAttestation == null) {
            return null;
        }
        return this.privateKeyAttestation.decodedBytes();
    }

    /**
     * Get the attestation blob bytes encoded as base64url string corresponding to a public key in case of asymmetric
     * key.
     *
     * @return The attestation blob bytes for the public portion of the key.
     */
    @Generated
    public byte[] getPublicKeyAttestation() {
        if (this.publicKeyAttestation == null) {
            return null;
        }
        return this.publicKeyAttestation.decodedBytes();
    }

    /**
     * Get the version of the attestation.
     *
     * @return The version of the attestation.
     */
    @Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificatePemFile", Objects.toString(this.certificatePemFile, null));
        jsonWriter.writeStringField("privateKeyAttestation", Objects.toString(this.privateKeyAttestation, null));
        jsonWriter.writeStringField("publicKeyAttestation", Objects.toString(this.publicKeyAttestation, null));
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyAttestation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyAttestation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyAttestation.
     */
    @Generated
    public static KeyAttestation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyAttestation deserializedKeyAttestation = new KeyAttestation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificatePemFile".equals(fieldName)) {
                    deserializedKeyAttestation.certificatePemFile
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("privateKeyAttestation".equals(fieldName)) {
                    deserializedKeyAttestation.privateKeyAttestation
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("publicKeyAttestation".equals(fieldName)) {
                    deserializedKeyAttestation.publicKeyAttestation
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("version".equals(fieldName)) {
                    deserializedKeyAttestation.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedKeyAttestation;
        });
    }
}
