// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.security.keyvault.keys.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * JSON web key operations. For more information, see JsonWebKeyOperation.
 */
public final class KeyOperation extends ExpandableStringEnum<KeyOperation> {

    /**
     * Indicates that the key can be used to encrypt.
     */
    @Generated
    public static final KeyOperation ENCRYPT = fromString("encrypt");

    /**
     * Indicates that the key can be used to decrypt.
     */
    @Generated
    public static final KeyOperation DECRYPT = fromString("decrypt");

    /**
     * Indicates that the key can be used to sign.
     */
    @Generated
    public static final KeyOperation SIGN = fromString("sign");

    /**
     * Indicates that the key can be used to verify.
     */
    @Generated
    public static final KeyOperation VERIFY = fromString("verify");

    /**
     * Indicates that the key can be used to wrap another key.
     */
    @Generated
    public static final KeyOperation WRAP_KEY = fromString("wrapKey");

    /**
     * Indicates that the key can be used to unwrap another key.
     */
    @Generated
    public static final KeyOperation UNWRAP_KEY = fromString("unwrapKey");

    /**
     * Indicates that the key can be imported during creation.
     */
    @Generated
    public static final KeyOperation IMPORT = fromString("import");

    /**
     * Indicates that the private component of the key can be exported.
     */
    @Generated
    private static final KeyOperation EXPORT = fromString("export");

    /**
     * Creates a new instance of KeyOperation value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public KeyOperation() {
    }

    /**
     * Creates or finds a KeyOperation from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KeyOperation.
     */
    @Generated
    public static KeyOperation fromString(String name) {
        return fromString(name, KeyOperation.class);
    }

    /**
     * Gets known KeyOperation values.
     *
     * @return known KeyOperation values.
     */
    @Generated
    public static Collection<KeyOperation> values() {
        return values(KeyOperation.class);
    }
}
