/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class KeyRestoreParameters
implements JsonSerializable<KeyRestoreParameters> {
    private final Base64Url keyBundleBackup;

    public KeyRestoreParameters(byte[] keyBundleBackup) {
        this.keyBundleBackup = keyBundleBackup == null ? null : Base64Url.encode((byte[])keyBundleBackup);
    }

    public byte[] getKeyBundleBackup() {
        if (this.keyBundleBackup == null) {
            return null;
        }
        return this.keyBundleBackup.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.keyBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyRestoreParameters)jsonReader.readObject(reader -> {
            byte[] keyBundleBackup = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    Base64Url keyBundleBackupHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (keyBundleBackupHolder == null) continue;
                    keyBundleBackup = keyBundleBackupHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyRestoreParameters(keyBundleBackup);
        });
    }
}

