/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={KeyClient.class})
public final class KeyClientBuilder {
    private final ClientLogger logger = new ClientLogger(KeyClientBuilder.class);
    private static final String AZURE_KEY_VAULT_KEYS = "azure-key-vault-keys.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> policies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private URL vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy = new RetryPolicy();
    private Configuration configuration;
    private KeyServiceVersion version;

    public KeyClientBuilder() {
        this.httpLogOptions = new HttpLogOptions();
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_KEYS);
    }

    public KeyClient buildClient() {
        return new KeyClient(this.buildAsyncClient());
    }

    public KeyAsyncClient buildAsyncClient() {
        KeyServiceVersion serviceVersion;
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        URL buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required")));
        }
        KeyServiceVersion keyServiceVersion = serviceVersion = this.version != null ? this.version : KeyServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new KeyAsyncClient(this.vaultUrl, this.pipeline, serviceVersion);
        }
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("credential_required")));
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.add(new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new KeyAsyncClient(this.vaultUrl, pipeline, serviceVersion);
    }

    public KeyClientBuilder vaultUrl(String vaultUrl) {
        try {
            this.vaultUrl = new URL(vaultUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault url is malformed.", ex));
        }
        return this;
    }

    public KeyClientBuilder credential(TokenCredential credential) {
        Objects.requireNonNull(credential);
        this.credential = credential;
        return this;
    }

    public KeyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public KeyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.policies.add(policy);
        return this;
    }

    public KeyClientBuilder httpClient(HttpClient client) {
        Objects.requireNonNull(client);
        this.httpClient = client;
        return this;
    }

    public KeyClientBuilder pipeline(HttpPipeline pipeline) {
        Objects.requireNonNull(pipeline);
        this.pipeline = pipeline;
        return this;
    }

    public KeyClientBuilder serviceVersion(KeyServiceVersion version) {
        this.version = version;
        return this;
    }

    public KeyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public KeyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "The retry policy cannot be bull");
        this.retryPolicy = retryPolicy;
        return this;
    }

    private URL getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty((CharSequence)configEndpoint)) {
            return null;
        }
        try {
            return new URL(configEndpoint);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

