/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyService;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.KeyOperationParameters;
import com.azure.security.keyvault.keys.cryptography.KeyOperationResult;
import com.azure.security.keyvault.keys.cryptography.KeySignRequest;
import com.azure.security.keyvault.keys.cryptography.KeyVerifyRequest;
import com.azure.security.keyvault.keys.cryptography.KeyVerifyResponse;
import com.azure.security.keyvault.keys.cryptography.KeyWrapUnwrapRequest;
import com.azure.security.keyvault.keys.cryptography.SecretKey;
import com.azure.security.keyvault.keys.cryptography.SecretRequestAttributes;
import com.azure.security.keyvault.keys.cryptography.SecretRequestParameters;
import com.azure.security.keyvault.keys.cryptography.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import reactor.core.publisher.Mono;

class CryptographyServiceClient {
    final String apiVersion;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private final ClientLogger logger = new ClientLogger(CryptographyServiceClient.class);
    private final CryptographyService service;
    private String vaultUrl;
    private String version;
    private String keyName;
    private final String keyId;

    CryptographyServiceClient(String keyId, CryptographyService service, CryptographyServiceVersion serviceVersion) {
        Objects.requireNonNull(keyId);
        this.unpackId(keyId);
        this.keyId = keyId;
        this.service = service;
        this.apiVersion = serviceVersion.getVersion();
    }

    Mono<Response<KeyVaultKey>> getKey(Context context) {
        if (this.version == null) {
            this.version = "";
        }
        return this.getKey(this.keyName, this.version, context);
    }

    private Mono<Response<KeyVaultKey>> getKey(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getKey(this.vaultUrl, name, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Retrieving key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Retrieved key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    Mono<Response<JsonWebKey>> getSecretKey(Context context) {
        return this.service.getSecret(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Retrieving key - {}", new Object[]{this.keyName})).doOnSuccess(response -> this.logger.info("Retrieved key - {}", new Object[]{((SecretKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{this.keyName, error})).flatMap(stringResponse -> {
            Object key = null;
            try {
                return Mono.just((Object)new SimpleResponse(stringResponse.getRequest(), stringResponse.getStatusCode(), stringResponse.getHeaders(), (Object)this.transformSecretKey((SecretKey)stringResponse.getValue())));
            }
            catch (JsonProcessingException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    Mono<Response<SecretKey>> setSecretKey(SecretKey secret, Context context) {
        context = context == null ? Context.NONE : context;
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(secret.getValue()).setTags(secret.getProperties().getTags()).setContentType(secret.getProperties().getContentType()).setSecretAttributes(new SecretRequestAttributes(secret.getProperties()));
        return this.service.setSecret(this.vaultUrl, secret.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Setting secret - {}", new Object[]{secret.getName()})).doOnSuccess(response -> this.logger.info("Set secret - {}", new Object[]{((SecretKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to set secret - {}", new Object[]{secret.getName(), error}));
    }

    JsonWebKey transformSecretKey(SecretKey secretKey) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        ArrayNode a = mapper.createArrayNode();
        a.add(KeyOperation.WRAP_KEY.toString());
        a.add(KeyOperation.UNWRAP_KEY.toString());
        a.add(KeyOperation.ENCRYPT.toString());
        a.add(KeyOperation.DECRYPT.toString());
        rootNode.put("k", Base64.getUrlDecoder().decode(secretKey.getValue()));
        rootNode.put("kid", this.keyId);
        rootNode.put("kty", KeyType.OCT.toString());
        rootNode.put("key_ops", (JsonNode)a);
        String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        return (JsonWebKey)mapper.readValue(jsonString, JsonWebKey.class);
    }

    Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(plaintext);
        context = context == null ? Context.NONE : context;
        return this.service.encrypt(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Encrypting content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved encrypted content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to encrypt content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new EncryptResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] cipherText, Context context) {
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(cipherText);
        context = context == null ? Context.NONE : context;
        return this.service.decrypt(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Decrypting content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved decrypted content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to decrypt content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new DecryptResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        KeySignRequest parameters = new KeySignRequest().setAlgorithm(algorithm).setValue(digest);
        context = context == null ? Context.NONE : context;
        return this.service.sign(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Signing content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved signed content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to sign content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new SignResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        KeyVerifyRequest parameters = new KeyVerifyRequest().setAlgorithm(algorithm).setDigest(digest).setSignature(signature);
        context = context == null ? Context.NONE : context;
        return this.service.verify(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Verifying content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved verified content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to verify content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(response -> Mono.just((Object)new VerifyResult(((KeyVerifyResponse)response.getValue()).getValue(), algorithm, this.keyId)));
    }

    Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(key);
        context = context == null ? Context.NONE : context;
        return this.service.wrapKey(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Wrapping key content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved wrapped key content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to verify content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new WrapResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(encryptedKey);
        context = context == null ? Context.NONE : context;
        return this.service.unwrapKey(this.vaultUrl, this.keyName, this.version, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)"Microsoft.KeyVault")).doOnRequest(ignored -> this.logger.info("Unwrapping key content with algorithm - {}", new Object[]{algorithm.toString()})).doOnSuccess(response -> this.logger.info("Retrieved unwrapped key content with algorithm- {}", new Object[]{algorithm.toString()})).doOnError(error -> this.logger.warning("Failed to unwrap key content with algorithm - {}", new Object[]{algorithm.toString(), error})).flatMap(response -> Mono.just((Object)new UnwrapResult(((KeyOperationResult)response.getValue()).getResult(), algorithm, this.keyId)));
    }

    Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.sign(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verify(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    private void unpackId(String keyId) {
        if (keyId != null && keyId.length() > 0) {
            try {
                URL url = new URL(keyId);
                String[] tokens = url.getPath().split("/");
                this.vaultUrl = url.getProtocol() + "://" + url.getHost();
                this.keyName = tokens.length >= 3 ? tokens[2] : null;
                this.version = tokens.length >= 4 ? tokens[3] : null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

