/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.AsymmetricSignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceClient;
import com.azure.security.keyvault.keys.cryptography.Ecdsa;
import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.ISignatureTransform;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import reactor.core.publisher.Mono;

class EcKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private final ClientLogger logger = new ClientLogger(EcKeyCryptographyClient.class);
    private KeyPair keyPair;
    private final CryptographyServiceClient serviceClient;
    private final Provider provider;

    EcKeyCryptographyClient(CryptographyServiceClient serviceClient) {
        super(serviceClient);
        this.serviceClient = serviceClient;
        this.provider = null;
    }

    EcKeyCryptographyClient(JsonWebKey key, CryptographyServiceClient serviceClient) {
        super(serviceClient);
        this.provider = Security.getProvider("SunEC");
        this.keyPair = key.toEc(key.hasPrivateKey(), this.provider);
        this.serviceClient = serviceClient;
    }

    private KeyPair getKeyPair(JsonWebKey key) {
        if (this.keyPair == null) {
            this.keyPair = key.toEc(key.hasPrivateKey());
        }
        return this.keyPair;
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context, JsonWebKey key) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptParameters options, Context context, JsonWebKey key) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context, JsonWebKey key) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<DecryptResult> decryptAsync(DecryptParameters options, Context context, JsonWebKey key) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Decrypt operation is not supported for EC key"));
    }

    @Override
    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context, JsonWebKey key) {
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceCryptoAvailable()) {
                return this.serviceClient.sign(algorithm, digest, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceCryptoAvailable()) {
                return this.serviceClient.sign(algorithm, digest, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Private portion of the key not available to perform sign operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Mono.just((Object)new SignResult(signer.sign(digest), algorithm, key.getId()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context, JsonWebKey key) {
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceCryptoAvailable()) {
                return this.serviceClient.verify(algorithm, digest, signature, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceCryptoAvailable()) {
                return this.serviceClient.verify(algorithm, digest, signature, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Public portion of the key not available to perform verify operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Mono.just((Object)new VerifyResult(signer.verify(digest, signature), algorithm, key.getId()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, Context context, JsonWebKey webKey) {
        return Mono.error((Throwable)new UnsupportedOperationException("Wrap key operation is not supported for EC key"));
    }

    @Override
    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context, JsonWebKey key) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Unwrap key operation is not supported for Ec key"));
    }

    @Override
    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context, JsonWebKey key) {
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.signAsync(algorithm, digest, context, key);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context, JsonWebKey key) {
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verifyAsync(algorithm, digest, signature, context, key);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    private boolean serviceCryptoAvailable() {
        return this.serviceClient != null;
    }
}

