/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyService;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;

@ServiceClient(builder=KeyClientBuilder.class, serviceInterfaces={KeyService.class})
public final class KeyClient {
    private final KeyAsyncClient client;

    KeyClient(KeyAsyncClient client) {
        this.client = client;
    }

    public String getVaultUrl() {
        return this.client.getVaultUrl();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(String name, KeyType keyType) {
        return (KeyVaultKey)this.createKeyWithResponse(new CreateKeyOptions(name, keyType), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(CreateKeyOptions createKeyOptions) {
        return (KeyVaultKey)this.createKeyWithResponse(createKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        return (Response)this.client.createKeyWithResponse(createKeyOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return (KeyVaultKey)this.createRsaKeyWithResponse(createRsaKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        return (Response)this.client.createRsaKeyWithResponse(createRsaKeyOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return (KeyVaultKey)this.createEcKeyWithResponse(createEcKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        return (Response)this.client.createEcKeyWithResponse(createEcKeyOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return (KeyVaultKey)this.createOctKeyWithResponse(createOctKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        return (Response)this.client.createOctKeyWithResponse(createOctKeyOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(String name, JsonWebKey keyMaterial) {
        return (KeyVaultKey)this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(ImportKeyOptions importKeyOptions) {
        return (KeyVaultKey)this.importKeyWithResponse(importKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        return (Response)this.client.importKeyWithResponse(importKeyOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name, String version) {
        return (KeyVaultKey)this.getKeyWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(String name, String version, Context context) {
        return (Response)this.client.getKeyWithResponse(name, version, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name) {
        return (KeyVaultKey)this.getKeyWithResponse(name, "", Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return (KeyVaultKey)this.updateKeyPropertiesWithResponse(keyProperties, Context.NONE, keyOperations).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        return (Response)this.client.updateKeyPropertiesWithResponse(keyProperties, context, keyOperations).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedKey, Void> beginDeleteKey(String name) {
        return this.client.beginDeleteKey(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKey getDeletedKey(String name) {
        return (DeletedKey)this.getDeletedKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKey> getDeletedKeyWithResponse(String name, Context context) {
        return (Response)this.client.getDeletedKeyWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedKey(String name) {
        this.purgeDeletedKeyWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String name, Context context) {
        return (Response)this.client.purgeDeletedKeyWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return this.client.beginRecoverDeletedKey(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupKey(String name) {
        return (byte[])this.backupKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupKeyWithResponse(String name, Context context) {
        return (Response)this.client.backupKeyWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey restoreKeyBackup(byte[] backup) {
        return (KeyVaultKey)this.restoreKeyBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        return (Response)this.client.restoreKeyBackupWithResponse(backup, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys() {
        return this.listPropertiesOfKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedIterable(this.client.listPropertiesOfKeys(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys() {
        return this.listDeletedKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys(Context context) {
        return new PagedIterable(this.client.listDeletedKeys(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name) {
        return this.listPropertiesOfKeyVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedIterable(this.client.listPropertiesOfKeyVersions(name, context));
    }
}

