/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.keys.KeyBackup;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyImportRequestParameters;
import com.azure.security.keyvault.keys.KeyReleaseParameters;
import com.azure.security.keyvault.keys.KeyRequestAttributes;
import com.azure.security.keyvault.keys.KeyRequestParameters;
import com.azure.security.keyvault.keys.KeyRestoreRequestParameters;
import com.azure.security.keyvault.keys.KeyService;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicyAttributes;
import com.azure.security.keyvault.keys.implementation.models.LifetimeAction;
import com.azure.security.keyvault.keys.implementation.models.LifetimeActionTrigger;
import com.azure.security.keyvault.keys.implementation.models.LifetimeActionsType;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationLifetimeAction;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyRotationPolicyProperties;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.RandomBytes;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyClientBuilder.class, isAsync=true, serviceInterfaces={KeyService.class})
public final class KeyAsyncClient {
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final KeyService service;
    private final ClientLogger logger = new ClientLogger(KeyAsyncClient.class);
    private final HttpPipeline pipeline;
    private final KeyServiceVersion keyServiceVersion;

    KeyAsyncClient(URL vaultUrl, HttpPipeline pipeline, KeyServiceVersion version) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.service = (KeyService)RestProxy.create(KeyService.class, (HttpPipeline)pipeline);
        this.pipeline = pipeline;
        this.keyServiceVersion = version;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    ClientLogger getLogger() {
        return this.logger;
    }

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName) {
        return this.getCryptographyClientBuilder(keyName, null).buildAsyncClient();
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName, String keyVersion) {
        return this.getCryptographyClientBuilder(keyName, keyVersion).buildAsyncClient();
    }

    CryptographyClientBuilder getCryptographyClientBuilder(String keyName, String keyVersion) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty."));
        }
        return new CryptographyClientBuilder().keyIdentifier(this.generateKeyId(keyName, keyVersion)).pipeline(this.pipeline).serviceVersion(CryptographyServiceVersion.valueOf(this.keyServiceVersion.name()));
    }

    String generateKeyId(String keyName, String keyVersion) {
        StringBuilder stringBuilder = new StringBuilder(this.vaultUrl);
        if (!this.vaultUrl.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("keys/").append(keyName);
        if (!CoreUtils.isNullOrEmpty((CharSequence)keyVersion)) {
            stringBuilder.append("/").append(keyVersion);
        }
        return stringBuilder.toString();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(String name, KeyType keyType) {
        try {
            return FluxUtil.withContext(context -> this.createKeyWithResponse(name, keyType, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createKeyWithResponse(createKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createKeyWithResponse(String name, KeyType keyType, Context context) {
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(keyType);
        return this.service.createKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(CreateKeyOptions createKeyOptions) {
        try {
            return this.createKeyWithResponse(createKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        Objects.requireNonNull(createKeyOptions, "The key create options parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createKeyOptions.getKeyType()).setKeyOps(createKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createKeyOptions)).setTags(createKeyOptions.getTags()).setReleasePolicy(createKeyOptions.getReleasePolicy());
        return this.service.createKey(this.vaultUrl, createKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{createKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{createKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            return this.createRsaKeyWithResponse(createRsaKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createRsaKeyWithResponse(createRsaKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        Objects.requireNonNull(createRsaKeyOptions, "The Rsa key options parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createRsaKeyOptions.getKeyType()).setKeySize(createRsaKeyOptions.getKeySize()).setKeyOps(createRsaKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createRsaKeyOptions)).setPublicExponent(createRsaKeyOptions.getPublicExponent()).setTags(createRsaKeyOptions.getTags()).setReleasePolicy(createRsaKeyOptions.getReleasePolicy());
        return this.service.createKey(this.vaultUrl, createRsaKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating Rsa key - {}", new Object[]{createRsaKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created Rsa key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create Rsa key - {}", new Object[]{createRsaKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        try {
            return this.createEcKeyWithResponse(createEcKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createEcKeyWithResponse(createEcKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        Objects.requireNonNull(createEcKeyOptions, "The Ec key options cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createEcKeyOptions.getKeyType()).setCurve(createEcKeyOptions.getCurveName()).setKeyOps(createEcKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createEcKeyOptions)).setTags(createEcKeyOptions.getTags()).setReleasePolicy(createEcKeyOptions.getReleasePolicy());
        return this.service.createKey(this.vaultUrl, createEcKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating Ec key - {}", new Object[]{createEcKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created Ec key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create Ec key - {}", new Object[]{createEcKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        try {
            return this.createOctKeyWithResponse(createOctKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createOctKeyWithResponse(createOctKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        Objects.requireNonNull(createOctKeyOptions, "The create key options cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createOctKeyOptions.getKeyType()).setKeySize(createOctKeyOptions.getKeySize()).setKeyOps(createOctKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createOctKeyOptions)).setTags(createOctKeyOptions.getTags()).setReleasePolicy(createOctKeyOptions.getReleasePolicy());
        return this.service.createKey(this.vaultUrl, createOctKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating symmetric key - {}", new Object[]{createOctKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created symmetric key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create symmetric key - {}", new Object[]{createOctKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(String name, JsonWebKey keyMaterial) {
        try {
            return FluxUtil.withContext(context -> this.importKeyWithResponse(name, keyMaterial, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> importKeyWithResponse(String name, JsonWebKey keyMaterial, Context context) {
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(keyMaterial);
        return this.service.importKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(ImportKeyOptions importKeyOptions) {
        try {
            return this.importKeyWithResponse(importKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.importKeyWithResponse(importKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        Objects.requireNonNull(importKeyOptions, "The key import configuration parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(importKeyOptions.getKey()).setHsm(importKeyOptions.isHardwareProtected()).setKeyAttributes(new KeyRequestAttributes(importKeyOptions)).setTags(importKeyOptions.getTags()).setReleasePolicy(importKeyOptions.getReleasePolicy());
        return this.service.importKey(this.vaultUrl, importKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{importKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{importKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name, String version) {
        try {
            return this.getKeyWithResponse(name, version).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version) {
        try {
            return FluxUtil.withContext(context -> this.getKeyWithResponse(name, version == null ? "" : version, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getKey(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name) {
        try {
            return this.getKeyWithResponse(name, "").flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            return FluxUtil.withContext(context -> this.updateKeyPropertiesWithResponse(keyProperties, (Context)context, keyOperations));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            return this.updateKeyPropertiesWithResponse(keyProperties, keyOperations).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        Objects.requireNonNull(keyProperties, "The key properties input parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setTags(keyProperties.getTags()).setKeyAttributes(new KeyRequestAttributes(keyProperties)).setReleasePolicy(keyProperties.getReleasePolicy());
        if (keyOperations.length > 0) {
            parameters.setKeyOps(Arrays.asList(keyOperations));
        }
        return this.service.updateKey(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating key - {}", new Object[]{keyProperties.getName()})).doOnSuccess(response -> this.logger.verbose("Updated key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to update key - {}", new Object[]{keyProperties.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedKey, Void> beginDeleteKey(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(name), this.createPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedKey>, Mono<DeletedKey>> activationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteKeyWithResponse(name, (Context)context)).flatMap(deletedKeyResponse -> Mono.just((Object)((DeletedKey)deletedKeyResponse.getValue())));
    }

    private Function<PollingContext<DeletedKey>, Mono<PollResponse<DeletedKey>>> createPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedKeyPoller(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedKeyResponse -> {
            if (deletedKeyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)deletedKeyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<DeletedKey>> deleteKeyWithResponse(String name, Context context) {
        return this.service.deleteKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKey> getDeletedKey(String name) {
        try {
            return this.getDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.getDeletedKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getDeletedKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKey(String name) {
        try {
            return this.purgeDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.purgeDeletedKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> purgeDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.purgeDeletedKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Purging deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Purged deleted key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to purge deleted key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(name), this.createRecoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultKey>, Mono<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedKeyWithResponse(name, (Context)context)).flatMap(keyResponse -> Mono.just((Object)((KeyVaultKey)keyResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultKey>, Mono<PollResponse<KeyVaultKey>>> createRecoverPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getKeyPoller(this.vaultUrl, keyName, "", this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(keyResponse -> {
            if (keyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)keyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<KeyVaultKey>> recoverDeletedKeyWithResponse(String name, Context context) {
        return this.service.recoverDeletedKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Recovering deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Recovered deleted key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to recover deleted key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupKey(String name) {
        try {
            return this.backupKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.backupKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<byte[]>> backupKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.backupKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Backing up key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Backed up key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to backup key - {}", new Object[]{name, error})).flatMap(base64URLResponse -> Mono.just((Object)new SimpleResponse(base64URLResponse.getRequest(), base64URLResponse.getStatusCode(), base64URLResponse.getHeaders(), (Object)((KeyBackup)base64URLResponse.getValue()).getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> restoreKeyBackup(byte[] backup) {
        try {
            return this.restoreKeyBackupWithResponse(backup).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup) {
        try {
            return FluxUtil.withContext(context -> this.restoreKeyBackupWithResponse(backup, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        context = context == null ? Context.NONE : context;
        KeyRestoreRequestParameters parameters = new KeyRestoreRequestParameters().setKeyBackup(backup);
        return this.service.restoreKey(this.vaultUrl, this.keyServiceVersion.getVersion(), parameters, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Attempting to restore key")).doOnSuccess(response -> this.logger.verbose("Restored Key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to restore key - {}", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listKeysFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedFlux(() -> this.listKeysFirstPage(context), continuationToken -> this.listKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeysFirstPage(Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing keys")).doOnSuccess(response -> this.logger.verbose("Listed keys")).doOnError(error -> this.logger.warning("Failed to list keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKey> listDeletedKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listDeletedKeysFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listDeletedKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DeletedKey> listDeletedKeys(Context context) {
        return new PagedFlux(() -> this.listDeletedKeysFirstPage(context), continuationToken -> this.listDeletedKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next deleted keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysFirstPage(Context context) {
        try {
            return this.service.getDeletedKeys(this.vaultUrl, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing deleted keys")).doOnSuccess(response -> this.logger.verbose("Listed deleted keys")).doOnError(error -> this.logger.warning("Failed to list deleted keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listKeyVersionsFirstPage(name, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listKeyVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedFlux(() -> this.listKeyVersionsFirstPage(name, context), continuationToken -> this.listKeyVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsFirstPage(String name, Context context) {
        try {
            return this.service.getKeyVersions(this.vaultUrl, name, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing key versions - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Listed key versions - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to list key versions - {}", new Object[]{name, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next key versions page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next key versions page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next key versions page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RandomBytes> getRandomBytes(int count) {
        try {
            return FluxUtil.withContext(context -> this.getRandomBytesWithResponse(count, (Context)context).flatMap(FluxUtil::toMono));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RandomBytes>> getRandomBytesWithResponse(int count) {
        try {
            return FluxUtil.withContext(context -> this.getRandomBytesWithResponse(count, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<RandomBytes>> getRandomBytesWithResponse(int count, Context context) {
        try {
            return this.service.getRandomBytes(this.vaultUrl, this.keyServiceVersion.getVersion(), new GetRandomBytesRequest().setCount(count), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Getting {} random bytes.", new Object[]{count})).doOnSuccess(response -> this.logger.verbose("Got {} random bytes.", new Object[]{count})).doOnError(error -> this.logger.warning("Failed to get random bytes - {}", new Object[]{error})).map(response -> new SimpleResponse(response, (Object)new RandomBytes(((com.azure.security.keyvault.keys.implementation.models.RandomBytes)response.getValue()).getBytes())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String target) {
        try {
            return this.releaseKeyWithResponse(name, "", target, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String version, String target) {
        try {
            return this.releaseKeyWithResponse(name, version, target, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseKeyWithResponse(String name, String version, String target, ReleaseKeyOptions options) {
        try {
            return FluxUtil.withContext(context -> this.releaseKeyWithResponse(name, version, target, options, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<ReleaseKeyResult>> releaseKeyWithResponse(String name, String version, String target, ReleaseKeyOptions options, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)target)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'target' cannot be null or empty"));
            }
            options = options == null ? new ReleaseKeyOptions() : options;
            KeyReleaseParameters keyReleaseParameters = new KeyReleaseParameters().setTarget(target).setAlgorithm(options.getAlgorithm()).setNonce(options.getNonce());
            return this.service.release(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), keyReleaseParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Releasing key with name %s and version %s.", new Object[]{name, version})).doOnSuccess(response -> this.logger.verbose("Released key with name %s and version %s.", new Object[]{name, version})).doOnError(error -> this.logger.warning("Failed to release key - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> rotateKey(String name) {
        try {
            return this.rotateKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> rotateKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.rotateKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<KeyVaultKey>> rotateKeyWithResponse(String name, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            return this.service.rotateKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Rotating key with name %s.", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Rotated key with name %s.", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to rotate key - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicy(String name) {
        try {
            return this.getKeyRotationPolicyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.getKeyRotationPolicyWithResponse(name, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponse(String name, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            return this.service.getKeyRotationPolicy(this.vaultUrl, name, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving key rotation policy for key with name.", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved key rotation policy for key with name.", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to retrieve key rotation policy - {}", new Object[]{error})).map(response -> new SimpleResponse(response, (Object)this.toKeyRotationPolicy((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicy(String name, KeyRotationPolicyProperties keyRotationPolicyProperties) {
        try {
            return this.updateKeyRotationPolicyWithResponse(name, keyRotationPolicyProperties).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponse(String name, KeyRotationPolicyProperties keyRotationPolicyProperties) {
        try {
            return FluxUtil.withContext(context -> this.updateKeyRotationPolicyWithResponse(name, keyRotationPolicyProperties, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponse(String name, KeyRotationPolicyProperties keyRotationPolicyProperties, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            ArrayList<LifetimeAction> lifetimeActions = new ArrayList<LifetimeAction>();
            for (KeyRotationLifetimeAction lifetimeAction : keyRotationPolicyProperties.getLifetimeActions()) {
                lifetimeActions.add(new LifetimeAction().setAction(new LifetimeActionsType().setType(lifetimeAction.getType())).setTrigger(new LifetimeActionTrigger().setTimeAfterCreate(lifetimeAction.getTimeAfterCreate()).setTimeBeforeExpiry(lifetimeAction.getTimeBeforeExpiry())));
            }
            com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy keyRotationPolicy = new com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy().setAttributes(new KeyRotationPolicyAttributes().setExpiryTime(keyRotationPolicyProperties.getExpiryTime())).setLifetimeActions(lifetimeActions);
            return this.service.updateKeyRotationPolicy(this.vaultUrl, name, this.keyServiceVersion.getVersion(), keyRotationPolicy, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating key rotation policy for key with name.", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Updated key rotation policy for key with name.", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to retrieve key rotation policy - {}", new Object[]{error})).map(response -> new SimpleResponse(response, (Object)this.toKeyRotationPolicy((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private KeyRotationPolicy toKeyRotationPolicy(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy keyRotationPolicy) {
        if (keyRotationPolicy == null) {
            return null;
        }
        ArrayList<KeyRotationLifetimeAction> keyRotationLifetimeActions = null;
        if (keyRotationPolicy.getLifetimeActions() != null) {
            keyRotationLifetimeActions = new ArrayList<KeyRotationLifetimeAction>();
            for (LifetimeAction lifetimeAction : keyRotationPolicy.getLifetimeActions()) {
                keyRotationLifetimeActions.add(new KeyRotationLifetimeAction(lifetimeAction.getAction().getType()).setTimeBeforeExpiry(lifetimeAction.getTrigger().getTimeBeforeExpiry()).setTimeAfterCreate(lifetimeAction.getTrigger().getTimeAfterCreate()));
            }
        }
        OffsetDateTime createdOn = null;
        OffsetDateTime updatedOn = null;
        String expiryTime = null;
        if (keyRotationPolicy.getAttributes() != null) {
            createdOn = OffsetDateTime.of(LocalDateTime.ofEpochSecond(keyRotationPolicy.getAttributes().getCreatedOn(), 0, ZoneOffset.UTC), ZoneOffset.UTC);
            updatedOn = OffsetDateTime.of(LocalDateTime.ofEpochSecond(keyRotationPolicy.getAttributes().getUpdatedOn(), 0, ZoneOffset.UTC), ZoneOffset.UTC);
            expiryTime = keyRotationPolicy.getAttributes().getExpiryTime();
        }
        return new KeyRotationPolicy(keyRotationPolicy.getId(), createdOn, updatedOn).setExpiryTime(expiryTime).setLifetimeActions(keyRotationLifetimeActions);
    }
}

