/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.KeyBackup;
import com.azure.security.keyvault.keys.KeyImportRequestParameters;
import com.azure.security.keyvault.keys.KeyReleaseParameters;
import com.azure.security.keyvault.keys.KeyRequestParameters;
import com.azure.security.keyvault.keys.KeyRestoreRequestParameters;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyPage;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.KeyPropertiesPage;
import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import reactor.core.publisher.Mono;

@Host(value="{url}")
@ServiceInterface(name="KeyVault")
interface KeyService {
    @Post(value="keys/{key-name}/create")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> createKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="keys/{key-name}/{key-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> getKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="keys/{key-name}/{key-version}")
    @ExpectedResponses(value={200, 404})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> getKeyPoller(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Put(value="keys/{key-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<KeyVaultKey>> importKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyImportRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Delete(value="keys/{key-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedKey>> deleteKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Patch(value="keys/{key-name}/{key-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<KeyVaultKey>> updateKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Get(value="keys/{key-name}/versions")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    @ReturnValueWireType(value=KeyPropertiesPage.class)
    public Mono<PagedResponse<KeyProperties>> getKeyVersions(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Post(value="keys/{key-name}/backup")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyBackup>> backupKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="keys/restore")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> restoreKey(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") KeyRestoreRequestParameters var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="keys")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=KeyPropertiesPage.class)
    public Mono<PagedResponse<KeyProperties>> getKeys(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=KeyPropertiesPage.class)
    public Mono<PagedResponse<KeyProperties>> getKeys(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Get(value="deletedkeys")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedKeyPage.class)
    public Mono<PagedResponse<DeletedKey>> getDeletedKeys(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedKeyPage.class)
    public Mono<PagedResponse<DeletedKey>> getDeletedKeys(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Get(value="deletedkeys/{key-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedKey>> getDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="deletedkeys/{key-name}")
    @ExpectedResponses(value={200, 404})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<DeletedKey>> getDeletedKeyPoller(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Delete(value="deletedkeys/{key-name}")
    @ExpectedResponses(value={204})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<Void>> purgeDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="deletedkeys/{key-name}/recover")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> recoverDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="rng")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<RandomBytes>> getRandomBytes(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetRandomBytesRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

    @Post(value="keys/{key-name}/{key-version}/release")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<ReleaseKeyResult>> release(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyReleaseParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

    @Post(value="/keys/{key-name}/rotate")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> rotateKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

    @Get(value="/keys/{key-name}/rotationpolicy")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicy(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

    @Put(value="/keys/{key-name}/rotationpolicy")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicy(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyRotationPolicy var4, @HeaderParam(value="Accept") String var5, Context var6);
}

