/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.implementation.Base64UrlJsonDeserializer;
import com.azure.security.keyvault.keys.implementation.Base64UrlJsonSerializer;
import com.azure.security.keyvault.keys.implementation.ByteExtensions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

public final class KeyReleasePolicy {
    @JsonProperty(value="data")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    private byte[] data;
    @JsonProperty(value="contentType")
    private String contentType;

    KeyReleasePolicy() {
    }

    public KeyReleasePolicy(byte[] data) {
        Objects.requireNonNull(data, "'data' cannot be null.");
        this.data = ByteExtensions.clone(data);
    }

    public byte[] getData() {
        return ByteExtensions.clone(this.data);
    }

    public String getContentType() {
        return this.contentType;
    }

    public KeyReleasePolicy setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

