/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class SignatureHashResolver {
    public static final SignatureHashResolver DEFAULT = new SignatureHashResolver();
    private final ConcurrentMap<SignatureAlgorithm, HashAlgorithm> algorithms = new ConcurrentHashMap<SignatureAlgorithm, HashAlgorithm>();

    SignatureHashResolver() {
    }

    public HashAlgorithm get(SignatureAlgorithm signatureAlgorithm) {
        return (HashAlgorithm)((Object)this.algorithms.get((Object)signatureAlgorithm));
    }

    public void put(SignatureAlgorithm algorithm, HashAlgorithm hashAlgorithm) {
        this.algorithms.put(algorithm, hashAlgorithm);
    }

    public void remove(SignatureAlgorithm algorithm) {
        this.algorithms.remove((Object)algorithm);
    }

    static {
        DEFAULT.put(SignatureAlgorithm.ES256, HashAlgorithm.SHA_256);
        DEFAULT.put(SignatureAlgorithm.ES256K, HashAlgorithm.SHA_256);
        DEFAULT.put(SignatureAlgorithm.ES384, HashAlgorithm.SHA_384);
        DEFAULT.put(SignatureAlgorithm.ES512, HashAlgorithm.SHA_512);
        DEFAULT.put(SignatureAlgorithm.RS256, HashAlgorithm.SHA_256);
        DEFAULT.put(SignatureAlgorithm.RS384, HashAlgorithm.SHA_384);
        DEFAULT.put(SignatureAlgorithm.RS512, HashAlgorithm.SHA_512);
        DEFAULT.put(SignatureAlgorithm.PS256, HashAlgorithm.SHA_256);
        DEFAULT.put(SignatureAlgorithm.PS512, HashAlgorithm.SHA_512);
        DEFAULT.put(SignatureAlgorithm.PS384, HashAlgorithm.SHA_384);
    }
}

