// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/** The attributes of a key managed by the key vault service. */
@Fluent
public final class KeyAttributes extends Attributes {
    /*
     * softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
     */
    private Integer recoverableDays;

    /*
     * Reflects the deletion recovery level currently in effect for keys in the current vault. If it contains
     * 'Purgeable' the key can be permanently deleted by a privileged user; otherwise, only the system can purge the
     * key, at the end of the retention interval.
     */
    private DeletionRecoveryLevel recoveryLevel;

    /*
     * Indicates if the private key can be exported. Release policy must be provided when creating the first version of
     * an exportable key.
     */
    private Boolean exportable;

    /** Creates an instance of KeyAttributes class. */
    public KeyAttributes() {}

    /**
     * Get the recoverableDays property: softDelete data retention days. Value should be &gt;=7 and &lt;=90 when
     * softDelete enabled, otherwise 0.
     *
     * @return the recoverableDays value.
     */
    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    /**
     * Get the recoveryLevel property: Reflects the deletion recovery level currently in effect for keys in the current
     * vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged user; otherwise, only the
     * system can purge the key, at the end of the retention interval.
     *
     * @return the recoveryLevel value.
     */
    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    /**
     * Get the exportable property: Indicates if the private key can be exported. Release policy must be provided when
     * creating the first version of an exportable key.
     *
     * @return the exportable value.
     */
    public Boolean isExportable() {
        return this.exportable;
    }

    /**
     * Set the exportable property: Indicates if the private key can be exported. Release policy must be provided when
     * creating the first version of an exportable key.
     *
     * @param exportable the exportable value to set.
     * @return the KeyAttributes object itself.
     */
    public KeyAttributes setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyAttributes setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyAttributes setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyAttributes setExpires(OffsetDateTime expires) {
        super.setExpires(expires);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", isEnabled());
        if (getNotBefore() != null) {
            jsonWriter.writeNumberField("nbf", getNotBefore().toEpochSecond());
        }
        if (getExpires() != null) {
            jsonWriter.writeNumberField("exp", getExpires().toEpochSecond());
        }
        jsonWriter.writeBooleanField("exportable", this.exportable);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyAttributes from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyAttributes if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyAttributes.
     */
    public static KeyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyAttributes deserializedKeyAttributes = new KeyAttributes();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("enabled".equals(fieldName)) {
                            deserializedKeyAttributes.setEnabled(reader.getNullable(JsonReader::getBoolean));
                        } else if ("nbf".equals(fieldName)) {
                            Long notBefore = reader.getNullable(JsonReader::getLong);
                            if (notBefore != null) {
                                deserializedKeyAttributes.setNotBefore(
                                        OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBefore), ZoneOffset.UTC));
                            }
                        } else if ("exp".equals(fieldName)) {
                            Long expires = reader.getNullable(JsonReader::getLong);
                            if (expires != null) {
                                deserializedKeyAttributes.setExpires(
                                        OffsetDateTime.ofInstant(Instant.ofEpochSecond(expires), ZoneOffset.UTC));
                            }
                        } else if ("created".equals(fieldName)) {
                            deserializedKeyAttributes.setCreated(reader.getNullable(JsonReader::getLong));
                        } else if ("updated".equals(fieldName)) {
                            deserializedKeyAttributes.setUpdated(reader.getNullable(JsonReader::getLong));
                        } else if ("recoverableDays".equals(fieldName)) {
                            deserializedKeyAttributes.recoverableDays = reader.getNullable(JsonReader::getInt);
                        } else if ("recoveryLevel".equals(fieldName)) {
                            deserializedKeyAttributes.recoveryLevel =
                                    DeletionRecoveryLevel.fromString(reader.getString());
                        } else if ("exportable".equals(fieldName)) {
                            deserializedKeyAttributes.exportable = reader.getNullable(JsonReader::getBoolean);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyAttributes;
                });
    }
}
