// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** The policy rules under which the key can be exported. */
@Fluent
public final class KeyReleasePolicy implements JsonSerializable<KeyReleasePolicy> {
    /*
     * Content type and version of key release policy
     */
    private String contentType;

    /*
     * Defines the mutability state of the policy. Once marked immutable, this flag cannot be reset and the policy
     * cannot be changed under any circumstances.
     */
    private Boolean immutable;

    /*
     * Blob encoding the policy rules under which the key can be released. Blob must be base64 URL encoded.
     */
    private Base64Url encodedPolicy;

    /** Creates an instance of KeyReleasePolicy class. */
    public KeyReleasePolicy() {}

    /**
     * Get the contentType property: Content type and version of key release policy.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Content type and version of key release policy.
     *
     * @param contentType the contentType value to set.
     * @return the KeyReleasePolicy object itself.
     */
    public KeyReleasePolicy setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the immutable property: Defines the mutability state of the policy. Once marked immutable, this flag cannot
     * be reset and the policy cannot be changed under any circumstances.
     *
     * @return the immutable value.
     */
    public Boolean isImmutable() {
        return this.immutable;
    }

    /**
     * Set the immutable property: Defines the mutability state of the policy. Once marked immutable, this flag cannot
     * be reset and the policy cannot be changed under any circumstances.
     *
     * @param immutable the immutable value to set.
     * @return the KeyReleasePolicy object itself.
     */
    public KeyReleasePolicy setImmutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    /**
     * Get the encodedPolicy property: Blob encoding the policy rules under which the key can be released. Blob must be
     * base64 URL encoded.
     *
     * @return the encodedPolicy value.
     */
    public byte[] getEncodedPolicy() {
        if (this.encodedPolicy == null) {
            return null;
        }
        return this.encodedPolicy.decodedBytes();
    }

    /**
     * Set the encodedPolicy property: Blob encoding the policy rules under which the key can be released. Blob must be
     * base64 URL encoded.
     *
     * @param encodedPolicy the encodedPolicy value to set.
     * @return the KeyReleasePolicy object itself.
     */
    public KeyReleasePolicy setEncodedPolicy(byte[] encodedPolicy) {
        if (encodedPolicy == null) {
            this.encodedPolicy = null;
        } else {
            this.encodedPolicy = Base64Url.encode(CoreUtils.clone(encodedPolicy));
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeBooleanField("immutable", this.immutable);
        jsonWriter.writeStringField("data", Objects.toString(this.encodedPolicy, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyReleasePolicy from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyReleasePolicy if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyReleasePolicy.
     */
    public static KeyReleasePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyReleasePolicy deserializedKeyReleasePolicy = new KeyReleasePolicy();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("contentType".equals(fieldName)) {
                            deserializedKeyReleasePolicy.contentType = reader.getString();
                        } else if ("immutable".equals(fieldName)) {
                            deserializedKeyReleasePolicy.immutable = reader.getNullable(JsonReader::getBoolean);
                        } else if ("data".equals(fieldName)) {
                            deserializedKeyReleasePolicy.encodedPolicy =
                                    reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyReleasePolicy;
                });
    }
}
