// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/** The key rotation policy attributes. */
@Fluent
public final class KeyRotationPolicyAttributes implements JsonSerializable<KeyRotationPolicyAttributes> {
    /*
     * The expiryTime will be applied on the new key version. It should be at least 28 days. It will be in ISO 8601
     * Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10 days: P1Y10D
     */
    private String expiryTime;

    /*
     * The key rotation policy created time in UTC.
     */
    private Long created;

    /*
     * The key rotation policy's last updated time in UTC.
     */
    private Long updated;

    /** Creates an instance of KeyRotationPolicyAttributes class. */
    public KeyRotationPolicyAttributes() {}

    /**
     * Get the expiryTime property: The expiryTime will be applied on the new key version. It should be at least 28
     * days. It will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10 days:
     * P1Y10D.
     *
     * @return the expiryTime value.
     */
    public String getExpiryTime() {
        return this.expiryTime;
    }

    /**
     * Set the expiryTime property: The expiryTime will be applied on the new key version. It should be at least 28
     * days. It will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10 days:
     * P1Y10D.
     *
     * @param expiryTime the expiryTime value to set.
     * @return the KeyRotationPolicyAttributes object itself.
     */
    public KeyRotationPolicyAttributes setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    /**
     * Get the created property: The key rotation policy created time in UTC.
     *
     * @return the created value.
     */
    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    /**
     * Get the updated property: The key rotation policy's last updated time in UTC.
     *
     * @return the updated value.
     */
    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiryTime", this.expiryTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyRotationPolicyAttributes from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyRotationPolicyAttributes if the JsonReader was pointing to an instance of it, or null
     *     if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyRotationPolicyAttributes.
     */
    public static KeyRotationPolicyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyRotationPolicyAttributes deserializedKeyRotationPolicyAttributes =
                            new KeyRotationPolicyAttributes();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("expiryTime".equals(fieldName)) {
                            deserializedKeyRotationPolicyAttributes.expiryTime = reader.getString();
                        } else if ("created".equals(fieldName)) {
                            deserializedKeyRotationPolicyAttributes.created = reader.getNullable(JsonReader::getLong);
                        } else if ("updated".equals(fieldName)) {
                            deserializedKeyRotationPolicyAttributes.updated = reader.getNullable(JsonReader::getLong);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyRotationPolicyAttributes;
                });
    }
}
