/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.implementation.AesKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.implementation.EcKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.RsaKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.SecretKey;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class CryptographyUtils {
    public static final String SECRETS_COLLECTION = "secrets";

    private CryptographyUtils() {
    }

    public static List<String> unpackAndValidateId(String keyId, ClientLogger logger) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyId' cannot be null or empty."));
        }
        try {
            String keyVersion;
            URL url = new URL(keyId);
            String[] tokens = url.getPath().split("/");
            String vaultUrl = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() != -1) {
                vaultUrl = vaultUrl + ":" + url.getPort();
            }
            String keyCollection = tokens.length >= 2 ? tokens[1] : null;
            String keyName = tokens.length >= 3 ? tokens[2] : null;
            String string = keyVersion = tokens.length >= 4 ? tokens[3] : null;
            if (CoreUtils.isNullOrEmpty((CharSequence)vaultUrl)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key endpoint in key identifier is invalid."));
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key name in key identifier is invalid."));
            }
            return Arrays.asList(vaultUrl, keyCollection, keyName, keyVersion);
        }
        catch (MalformedURLException e) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The key identifier is malformed.", e));
        }
    }

    public static LocalKeyCryptographyClient retrieveJwkAndCreateLocalClient(CryptographyClientImpl implClient) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)implClient.getKeyCollection())) {
            JsonWebKey jsonWebKey;
            JsonWebKey jsonWebKey2 = jsonWebKey = SECRETS_COLLECTION.equals(implClient.getKeyCollection()) ? implClient.getSecretKey() : ((KeyVaultKey)implClient.getKey(Context.NONE).getValue()).getKey();
            if (jsonWebKey == null) {
                throw new IllegalStateException("Could not retrieve JSON Web Key to perform local cryptographic operations.");
            }
            if (!jsonWebKey.isValid()) {
                throw new IllegalStateException("The retrieved JSON Web Key is not valid.");
            }
            return CryptographyUtils.createLocalClient(jsonWebKey, implClient);
        }
        throw new IllegalStateException("Could not create a local cryptography client.");
    }

    public static Mono<LocalKeyCryptographyClient> retrieveJwkAndCreateLocalAsyncClient(CryptographyClientImpl implClient) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)implClient.getKeyCollection())) {
            Mono jsonWebKeyMono = SECRETS_COLLECTION.equals(implClient.getKeyCollection()) ? implClient.getSecretKeyAsync() : implClient.getKeyAsync().map(keyVaultKeyResponse -> ((KeyVaultKey)keyVaultKeyResponse.getValue()).getKey());
            return jsonWebKeyMono.handle((jsonWebKey, sink) -> {
                if (!jsonWebKey.isValid()) {
                    sink.error((Throwable)new IllegalStateException("The retrieved JSON Web Key is not valid."));
                } else {
                    sink.next((Object)CryptographyUtils.createLocalClient(jsonWebKey, implClient));
                }
            });
        }
        return Mono.error((Throwable)new IllegalStateException("Could not create a local cryptography client. Key collection is null or empty."));
    }

    public static LocalKeyCryptographyClient createLocalClient(JsonWebKey jsonWebKey, CryptographyClientImpl implClient) {
        if (!KeyType.values().contains((Object)jsonWebKey.getKeyType())) {
            throw new IllegalArgumentException(String.format("The JSON Web Key type: %s is not supported.", jsonWebKey.getKeyType().toString()));
        }
        if (jsonWebKey.getKeyType().equals((Object)KeyType.RSA) || jsonWebKey.getKeyType().equals((Object)KeyType.RSA_HSM)) {
            return new RsaKeyCryptographyClient(jsonWebKey, implClient);
        }
        if (jsonWebKey.getKeyType().equals((Object)KeyType.EC) || jsonWebKey.getKeyType().equals((Object)KeyType.EC_HSM)) {
            return new EcKeyCryptographyClient(jsonWebKey, implClient);
        }
        if (jsonWebKey.getKeyType().equals((Object)KeyType.OCT) || jsonWebKey.getKeyType().equals((Object)KeyType.OCT_HSM)) {
            return new AesKeyCryptographyClient(jsonWebKey, implClient);
        }
        throw new IllegalStateException("Could not create local cryptography client.");
    }

    public static void verifyKeyPermissions(JsonWebKey jsonWebKey, KeyOperation keyOperation) {
        if (!jsonWebKey.getKeyOps().contains((Object)keyOperation)) {
            throw new UnsupportedOperationException(String.format("The %s operation is not allowed for key with id: %s", keyOperation.toString().toLowerCase(Locale.ROOT), jsonWebKey.getId()));
        }
    }

    public static boolean isThrowableRetryable(Throwable e) {
        if (e instanceof HttpResponseException) {
            int statusCode = ((HttpResponseException)e).getResponse().getStatusCode();
            return statusCode != 501 && statusCode != 505 && (statusCode >= 500 || statusCode == 408 || statusCode == 429);
        }
        return false;
    }

    static void validate(byte[] key, int keySizeInBytes) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length < keySizeInBytes) {
            throw new IllegalArgumentException(String.format("key must be at least %d bits long", keySizeInBytes << 3));
        }
    }

    static boolean sequenceEqualConstantTime(byte[] self, byte[] other) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        long difference = (long)self.length & 0xFFFFFFFFL ^ (long)other.length & 0xFFFFFFFFL;
        for (int i = 0; i < self.length && i < other.length; ++i) {
            difference |= (long)(self[i] ^ other[i]) & 0xFFFFFFFFL;
        }
        return difference == 0L;
    }

    static JsonWebKey transformSecretKey(SecretKey secretKey) {
        return new JsonWebKey().setId(secretKey.getId()).setK(Base64.getUrlDecoder().decode(secretKey.getValue())).setKeyType(KeyType.OCT).setKeyOps(Arrays.asList(KeyOperation.WRAP_KEY, KeyOperation.UNWRAP_KEY, KeyOperation.ENCRYPT, KeyOperation.DECRYPT));
    }

    static JsonWebKeyEncryptionAlgorithm mapKeyEncryptionAlgorithm(EncryptionAlgorithm algorithm) {
        return JsonWebKeyEncryptionAlgorithm.fromString(Objects.toString((Object)algorithm, null));
    }

    static JsonWebKeySignatureAlgorithm mapKeySignatureAlgorithm(SignatureAlgorithm algorithm) {
        return JsonWebKeySignatureAlgorithm.fromString(Objects.toString((Object)algorithm, null));
    }

    static JsonWebKeyEncryptionAlgorithm mapWrapAlgorithm(KeyWrapAlgorithm algorithm) {
        return JsonWebKeyEncryptionAlgorithm.fromString(Objects.toString((Object)algorithm, null));
    }
}

