// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/** The deleted key item containing the deleted key metadata and information about deletion. */
@Fluent
public final class DeletedKeyItem extends KeyItem {
    /*
     * The url of the recovery object, used to identify and recover the deleted key.
     */
    private String recoveryId;

    /*
     * The time when the key is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the key was deleted, in UTC
     */
    private Long deletedDate;

    /** Creates an instance of DeletedKeyItem class. */
    public DeletedKeyItem() {
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted key.
     *
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted key.
     *
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedKeyItem object itself.
     */
    public DeletedKeyItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the key is scheduled to be purged, in UTC.
     *
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the key was deleted, in UTC.
     *
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyItem setKid(String kid) {
        super.setKid(kid);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyItem setAttributes(KeyAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", getKid());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedKeyItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedKeyItem if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedKeyItem.
     */
    public static DeletedKeyItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedKeyItem deserializedDeletedKeyItem = new DeletedKeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kid".equals(fieldName)) {
                    deserializedDeletedKeyItem.setKid(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedKeyItem.setAttributes(KeyAttributes.fromJson(reader));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedKeyItem.setTags(tags);
                } else if ("managed".equals(fieldName)) {
                    deserializedDeletedKeyItem.setManaged(reader.getNullable(JsonReader::getBoolean));
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedKeyItem.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedKeyItem;
        });
    }
}
