// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/** The key item containing key metadata. */
@Fluent
public class KeyItem implements JsonSerializable<KeyItem> {
    /*
     * Key identifier.
     */
    private String kid;

    /*
     * The key management attributes.
     */
    private KeyAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /*
     * True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be
     * true.
     */
    private Boolean managed;

    /** Creates an instance of KeyItem class. */
    public KeyItem() {
    }

    /**
     * Get the kid property: Key identifier.
     *
     * @return the kid value.
     */
    public String getKid() {
        return this.kid;
    }

    /**
     * Set the kid property: Key identifier.
     *
     * @param kid the kid value to set.
     * @return the KeyItem object itself.
     */
    public KeyItem setKid(String kid) {
        this.kid = kid;
        return this;
    }

    /**
     * Get the attributes property: The key management attributes.
     *
     * @return the attributes value.
     */
    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The key management attributes.
     *
     * @param attributes the attributes value to set.
     * @return the KeyItem object itself.
     */
    public KeyItem setAttributes(KeyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @param tags the tags value to set.
     * @return the KeyItem object itself.
     */
    public KeyItem setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the managed property: True if the key's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     *
     * @return the managed value.
     */
    public Boolean isManaged() {
        return this.managed;
    }

    /**
     * Set the managed property: True if the key's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     *
     * @param managed the managed value to set.
     * @return the KeyItem object itself.
     */
    KeyItem setManaged(Boolean managed) {
        this.managed = managed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyItem if the JsonReader was pointing to an instance of it, or null if it was pointing to
     *     JSON null.
     * @throws IOException If an error occurs while reading the KeyItem.
     */
    public static KeyItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyItem deserializedKeyItem = new KeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kid".equals(fieldName)) {
                    deserializedKeyItem.kid = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedKeyItem.attributes = KeyAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyItem.tags = tags;
                } else if ("managed".equals(fieldName)) {
                    deserializedKeyItem.managed = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyItem;
        });
    }
}
