// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A list of keys that have been deleted in this vault.
 */
@Immutable
public final class DeletedKeyListResult implements JsonSerializable<DeletedKeyListResult> {
    /*
     * A response message containing a list of deleted keys in the vault along with a link to the next page of deleted
     * keys
     */
    private List<DeletedKeyItem> value;

    /*
     * The URL to get the next set of deleted keys.
     */
    private String nextLink;

    /**
     * Creates an instance of DeletedKeyListResult class.
     */
    public DeletedKeyListResult() {
    }

    /**
     * Get the value property: A response message containing a list of deleted keys in the vault along with a link to
     * the next page of deleted keys.
     * 
     * @return the value value.
     */
    public List<DeletedKeyItem> getValue() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of deleted keys.
     * 
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedKeyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedKeyListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedKeyListResult.
     */
    public static DeletedKeyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedKeyListResult deserializedDeletedKeyListResult = new DeletedKeyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DeletedKeyItem> value = reader.readArray(reader1 -> DeletedKeyItem.fromJson(reader1));
                    deserializedDeletedKeyListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDeletedKeyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedKeyListResult;
        });
    }
}
